/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class UF2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;
    double latv;
    double lonv;
    double elev;
    DateFormatter formatter = new DateFormatter();

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)).equals("UNIVERSALFORMAT");
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UF2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public UF2Dataset() {
    }

    public UF2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "UF 2 radar dataset";
        this.setEarthLocation();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect bb;
        if (this.origin == null) {
            return;
        }
        double dLat = Math.toDegrees(this.getMaximumRadialDist() / Earth.getRadius());
        double latRadians = Math.toRadians(this.origin.getLatitude());
        double dLon = dLat * Math.cos(latRadians);
        double lat1 = this.origin.getLatitude() - dLat / 2.0;
        double lon1 = this.origin.getLongitude() - dLon / 2.0;
        this.boundingBox = bb = new LatLonRect((LatLonPoint)new LatLonPointImpl(lat1, lon1), dLat, dLon);
    }

    double getMaximumRadialDist() {
        double maxdist = 0.0;
        for (RadialDatasetSweep.RadialVariable rv : this.dataVariables) {
            RadialDatasetSweep.Sweep sp = rv.getSweep(0);
            double dist = (float)sp.getGateNumber() * sp.getGateSize();
            if (!(dist > maxdist)) continue;
            maxdist = dist;
        }
        return maxdist;
    }

    @Override
    protected void setEarthLocation() {
        Attribute ga = this.ds.findGlobalAttribute("StationLatitude");
        this.latv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationLongitude");
        this.lonv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationElevationInMeters");
        this.elev = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("Station");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("StationName");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    @Override
    public String getDataFormat() {
        return "Universal Format";
    }

    @Override
    public boolean isVolume() {
        return true;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    protected void setTimeUnits() throws Exception {
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = axes.get(i);
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    @Override
    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = this.formatter.getISODate(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    @Override
    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = this.formatter.getISODate(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    @Override
    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        if (rnk == 3) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new UF2Variable(nds, v, v0);
    }

    public String getInfo() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("UF2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        RadialDatasetSweep.Sweep sw;
        int nsweep = rv.getNumSweeps();
        for (int i = 0; i < nsweep; ++i) {
            sw = rv.getSweep(i);
            float me = sw.getMeanElevation();
            System.out.println("*** radar Sweep mean elevation of sweep " + i + " is: " + me);
            int nrays = sw.getRadialNumber();
            float[] az = new float[nrays];
            for (int j = 0; j < nrays; ++j) {
                float azi;
                az[j] = azi = sw.getAzimuth(j);
            }
            float[] azz = sw.getAzimuth();
            float[] dat = sw.readData();
        }
        sw = rv.getSweep(0);
        float[] data = rv.readAllData();
        float[] ddd = sw.readData();
        float[] da = sw.getAzimuth();
        float[] de = sw.getElevation();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        float[] az = new float[nrays];
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            az[i] = azi;
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
        assert (0 != nrays);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/Desktop/idv/dorade/KATX_20040113_0107";
        long start = System.currentTimeMillis();
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        long took = System.currentTimeMillis() - start;
        System.out.println("that took = " + took + " msec");
        System.exit(0);
        String st = rds.getStartDate().toString();
        String et = rds.getEndDate().toString();
        String id = rds.getRadarID();
        String name = rds.getRadarName();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary with name and id: " + name + " " + id);
        }
        List<VariableSimpleIF> rvars = rds.getDataVariables();
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("Reflectivity");
        UF2Dataset.testRadialVariable(vDM);
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
            UF2Dataset.testRadialVariable(rv);
        }
    }

    private class UF2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        int nsweeps;
        ArrayList sweeps;
        String name;

        private UF2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(v.getName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.name = v.getName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.nsweeps = shape[--count];
            for (int i = 0; i < this.nsweeps; ++i) {
                this.sweeps.add(new UF2Sweep(v0, i, nrays, ngates));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getNumSweeps() {
            return this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return (RadialDatasetSweep.Sweep)this.sweeps.get(sweepNo);
        }

        public int getNumRadials() {
            return 0;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            Object hrData = null;
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(this.sweeps.size() - 1);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        @Override
        public void clearVariableMemory() {
            for (int i = 0; i < this.nsweeps; ++i) {
            }
        }

        private class UF2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int nrays;
            int ngates;
            int sweepno;
            Variable sweepVar;
            String abbrev;

            UF2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.sweepno = sweepno;
                this.nrays = rays;
                this.ngates = gates;
                Attribute att = this.sweepVar.findAttribute("abbrev");
                this.abbrev = att.getStringValue();
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                return this.sweepData(this.sweepno);
            }

            private float[] sweepData(int swpNumber) {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[3];
                Array sweepTmp = null;
                origin[0] = swpNumber;
                shape[0] = 1;
                try {
                    sweepTmp = this.sweepVar.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float[] readData(int ray) throws IOException {
                return this.rayData(this.sweepno, ray);
            }

            public float[] rayData(int swpNumber, int ray) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[3];
                Array sweepTmp = null;
                origin[0] = swpNumber;
                origin[1] = ray;
                shape[0] = 1;
                shape[1] = 1;
                try {
                    sweepTmp = this.sweepVar.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            public void setMeanElevation() {
                String eleName = "elevation" + this.abbrev;
                this.setMeanEle(eleName, this.sweepno);
            }

            private void setMeanEle(String elevName, int swpNumber) {
                Array eleData = null;
                float sum = 0.0f;
                int sumSize = 0;
                try {
                    Array eleTmp = UF2Dataset.this.ds.findVariable(elevName).read();
                    int[] eleOrigin = new int[]{swpNumber, 0};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleTmp.section(eleOrigin, eleShape);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                float[] eleArray = (float[])eleData.get1DJavaArray(Float.TYPE);
                int size = (int)eleData.getSize();
                for (int i = 0; i < size; ++i) {
                    if (Float.isNaN(eleArray[i])) continue;
                    sum += eleArray[i];
                    ++sumSize;
                }
                this.meanElevation = sum / (float)sumSize;
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            public double meanDouble(Array a) {
                double sum = 0.0;
                int size = 0;
                IndexIterator iterA = a.getIndexIterator();
                while (iterA.hasNext()) {
                    double s = iterA.getDoubleNext();
                    if (Double.isNaN(s)) continue;
                    sum += s;
                    ++size;
                }
                return sum / (double)size;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return UF2Dataset.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return UF2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return UF2Dataset.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            public void setMeanAzimuth() {
                String aziName = "azimuth" + this.abbrev;
                this.setMeanAzi(aziName, this.sweepno);
            }

            private void setMeanAzi(String aziName, int swpNumber) {
                Array aziData = null;
                if (this.getType() != null) {
                    try {
                        Array data = UF2Dataset.this.ds.findVariable(aziName).read();
                        int[] aziOrigin = new int[]{swpNumber, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = data.section(aziOrigin, aziShape);
                        this.meanAzimuth = MAMath.sumDouble(aziData) / (double)aziData.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.meanAzimuth = 0.0;
                }
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                String eleName = "elevation" + this.abbrev;
                return this.getEle(eleName, this.sweepno, ray);
            }

            public float getEle(String elevName, int swpNumber, int ray) throws IOException {
                Array eleData = null;
                try {
                    Array eleTmp = UF2Dataset.this.ds.findVariable(elevName).read();
                    int[] eleOrigin = new int[]{swpNumber, 0};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleTmp.section(eleOrigin, eleShape);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                Index index = eleData.getIndex();
                return eleData.getFloat(index.set(ray));
            }

            @Override
            public float[] getElevation() throws IOException {
                String eleName = "elevation" + this.abbrev;
                return this.getEle(eleName, this.sweepno);
            }

            public float[] getEle(String elevName, int swpNumber) throws IOException {
                Array eleData = null;
                if (eleData == null) {
                    try {
                        Array eleTmp = UF2Dataset.this.ds.findVariable(elevName).read();
                        int[] eleOrigin = new int[]{swpNumber, 0};
                        int[] eleShape = new int[]{1, this.getRadialNumber()};
                        eleData = eleTmp.section(eleOrigin, eleShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                return (float[])eleData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float[] getAzimuth() throws IOException {
                String aziName = "azimuth" + this.abbrev;
                return this.getAzi(aziName, this.sweepno);
            }

            public float[] getAzi(String aziName, int swpNumber) throws IOException {
                Array aziData = null;
                if (aziData == null) {
                    try {
                        Array aziTmp = UF2Dataset.this.ds.findVariable(aziName).read();
                        int[] aziOrigin = new int[]{swpNumber, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = aziTmp.section(aziOrigin, aziShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                return (float[])aziData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                String aziName = "azimuth" + this.abbrev;
                return this.getAzi(aziName, this.sweepno, ray);
            }

            public float getAzi(String aziName, int swpNumber, int ray) throws IOException {
                Array aziData = null;
                if (aziData == null) {
                    try {
                        Array aziTmp = UF2Dataset.this.ds.findVariable(aziName).read();
                        int[] aziOrigin = new int[]{swpNumber, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        aziData = aziTmp.section(aziOrigin, aziShape);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                }
                Index index = aziData.getIndex();
                return aziData.getFloat(index.set(ray));
            }

            public float getRadialDistance(int gate) throws IOException {
                String disName = "distance" + this.abbrev;
                return this.getRadialDist(disName, gate);
            }

            public float getRadialDist(String dName, int gate) throws IOException {
                Array data = UF2Dataset.this.ds.findVariable(dName).read();
                Index index = data.getIndex();
                return data.getFloat(index.set(gate));
            }

            @Override
            public float getTime(int ray) throws IOException {
                String tName = "time" + this.abbrev;
                return this.getT(tName, this.sweepno, ray);
            }

            public float getT(String tName, int swpNumber, int ray) throws IOException {
                Array timeData = UF2Dataset.this.ds.findVariable(tName).read();
                Index timeIndex = timeData.getIndex();
                return timeData.getFloat(timeIndex.set(swpNumber, ray));
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    return this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

