/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.Station;

public class StandardStationCollectionImpl
extends StationTimeSeriesCollectionImpl {
    private DateUnit timeUnit;
    private NestedTable ft;

    StandardStationCollectionImpl(NestedTable ft, DateUnit timeUnit) throws IOException {
        super(ft.getName());
        this.timeUnit = timeUnit;
        this.ft = ft;
    }

    public Station makeStation(StructureData stationData, int recnum) {
        Station s = this.ft.makeStation(stationData);
        if (s == null) {
            return null;
        }
        return new StandardStationFeatureImpl(s, this.timeUnit, stationData, recnum);
    }

    @Override
    protected void initStationHelper() {
        try {
            this.stationHelper = new StationHelper();
            StructureDataIterator siter = this.ft.getStationDataIterator(-1);
            while (siter.hasNext()) {
                StructureData stationData = siter.next();
                Station s = this.makeStation(stationData, siter.getCurrentRecno());
                if (s == null) continue;
                this.stationHelper.addStation(s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private class StandardStationFeatureImpl
    extends StationFeatureImpl {
        int recnum;
        StructureData stationData;

        StandardStationFeatureImpl(Station s, DateUnit dateUnit, StructureData stationData, int recnum) {
            super(s, dateUnit, -1);
            this.recnum = recnum;
            this.stationData = stationData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursor = new Cursor(StandardStationCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.recnum;
            cursor.tableData[1] = this.stationData;
            cursor.currentIndex = 1;
            StandardStationCollectionImpl.this.ft.addParentJoin(cursor);
            StructureDataIterator obsIter = StandardStationCollectionImpl.this.ft.getLeafFeatureDataIterator(cursor, bufferSize);
            StandardPointFeatureIterator iter = new StandardPointFeatureIterator(StandardStationCollectionImpl.this.ft, this.timeUnit, obsIter, cursor);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }
    }
}

