/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class ArrayStructureAdde
extends ArrayStructure {
    private int MISSING_VALUE_INT = -9999;
    private double MISSING_VALUE_DOUBLE = Double.NaN;
    protected int[][] data;
    protected double[] scaleFactor;

    public ArrayStructureAdde(StructureMembers members, int[] shape, int[][] data, double[] scaleFactor) {
        super(members, shape);
        this.data = data;
        this.scaleFactor = scaleFactor;
    }

    @Override
    public Array createView(Index index) {
        return new ArrayStructureAdde(this.members, index, this.nelems, this.sdata, this.data, this.scaleFactor);
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return null;
    }

    ArrayStructureAdde(StructureMembers members, Index ima, int nelems, StructureData[] sdata, int[][] storage, double[] scaleFactor) {
        super(members, ima);
        this.nelems = nelems;
        this.sdata = sdata;
        this.data = storage;
        this.scaleFactor = scaleFactor;
    }

    @Override
    public Object getStorage() {
        return this.data;
    }

    @Override
    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be double");
        }
        int param = m.getDataParam();
        int v = this.data[param][recnum];
        if (v == -2139062144) {
            return this.MISSING_VALUE_DOUBLE;
        }
        if (this.scaleFactor[param] != 0.0) {
            return (double)v * this.scaleFactor[param];
        }
        return v;
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        double[] data = new double[]{this.getScalarDouble(recnum, m)};
        return data;
    }

    @Override
    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public short getScalarShort(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be int");
        }
        int param = m.getDataParam();
        int v = this.data[param][recnum];
        if (v == -2139062144) {
            return this.MISSING_VALUE_INT;
        }
        return v;
    }

    @Override
    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        int[] data = new int[]{this.getScalarInt(recnum, m)};
        return data;
    }

    @Override
    public long getScalarLong(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public char getScalarChar(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.CHAR || m.getDataType() == DataType.STRING) {
            int param = m.getDataParam();
            return McIDASUtil.intBitsToString((int)this.data[param][recnum]);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
    }

    @Override
    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        return new String[0];
    }

    @Override
    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        return null;
    }

    @Override
    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m) {
        return null;
    }
}

