/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.units.TimeUnit;

public class DateType {
    private DateFormatter formatter = null;
    private String text;
    private String format;
    private String type;
    private boolean isPresent;
    private boolean isBlank;
    private Date date;
    private Calendar cal = null;

    public static String hiddenProperties() {
        return "text blank present";
    }

    public DateType(boolean isPresent, Date date) {
        this.isPresent = isPresent;
        this.date = date;
    }

    public DateType() {
        this.isBlank = true;
    }

    public DateType(DateType src) {
        this.text = src.getText();
        this.format = src.getFormat();
        this.type = src.getType();
        this.isPresent = src.isPresent();
        this.isBlank = src.isBlank();
        this.date = src.getDate();
    }

    public DateType(String text, String format, String type) throws ParseException {
        this.text = text = text == null ? "" : text.trim();
        this.format = format;
        this.type = type;
        if (text.length() == 0) {
            this.isBlank = true;
            return;
        }
        this.isPresent = text.equalsIgnoreCase("present");
        if (this.isPresent) {
            return;
        }
        if (format != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            this.date = dateFormat.parse(text);
            return;
        }
        if (text.indexOf("since") > 0) {
            this.date = DateUnit.getStandardDate(text);
            if (this.date == null) {
                throw new ParseException("invalid udunit date unit", 0);
            }
            return;
        }
        if (null == this.formatter) {
            this.formatter = new DateFormatter();
        }
        this.date = this.formatter.getISODate(text);
        if (this.date == null) {
            throw new ParseException("invalid ISO date unit", 0);
        }
    }

    public Date getDate() {
        return this.isPresent() ? new Date() : this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.text = null;
        this.isPresent = false;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getText() {
        if (this.isPresent) {
            this.text = "present";
        }
        if (this.text == null) {
            this.text = this.toDateTimeString();
        }
        return this.text;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean before(Date d) {
        if (this.isPresent()) {
            return false;
        }
        return this.date.before(d);
    }

    public boolean before(DateType d) {
        if (d.isPresent()) {
            return true;
        }
        if (this.isPresent()) {
            return false;
        }
        return this.date.before(d.getDate());
    }

    public boolean after(Date d) {
        if (this.isPresent()) {
            return true;
        }
        return this.date.after(d);
    }

    public String toDateString() {
        if (null == this.formatter) {
            this.formatter = new DateFormatter();
        }
        return this.formatter.toDateOnlyString(this.getDate());
    }

    public String toDateTimeString() {
        if (null == this.formatter) {
            this.formatter = new DateFormatter();
        }
        return this.formatter.toDateTimeString(this.getDate());
    }

    public String toDateTimeStringISO() {
        if (null == this.formatter) {
            this.formatter = new DateFormatter();
        }
        return this.formatter.toDateTimeStringISO(this.getDate());
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        if (this.isBlank()) {
            return 0;
        }
        if (this.isPresent()) {
            return 1;
        }
        return this.getDate().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateType)) {
            return false;
        }
        DateType oo = (DateType)o;
        if (this.isPresent() && oo.isPresent()) {
            return true;
        }
        if (this.isBlank() && oo.isBlank()) {
            return true;
        }
        return oo.getDate().equals(this.getDate());
    }

    public DateType add(TimeDuration d) {
        return this.add(d.getTimeUnit());
    }

    public DateType add(TimeUnit d) {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        this.cal.setTime(this.getDate());
        this.cal.add(13, (int)d.getValueInSeconds());
        return new DateType(false, (Date)this.cal.getTime().clone());
    }

    public DateType subtract(TimeDuration d) {
        return this.subtract(d.getTimeUnit());
    }

    public DateType subtract(TimeUnit d) {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        this.cal.setTime(this.getDate());
        this.cal.add(13, (int)(-d.getValueInSeconds()));
        return new DateType(false, (Date)this.cal.getTime().clone());
    }

    private static void doOne(String s) {
        try {
            System.out.println("\nString = (" + s + ")");
            DateType d = new DateType(s, null, null);
            System.out.println("DateType = (" + d.toString() + ")");
            System.out.println("Date = (" + d.getDate() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DateType.doOne("T00:00:00Z");
    }
}

