/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Rule;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Strategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Rule entryRule;
    private Rule exitRule;
    private int unstablePeriod;

    public Strategy(Rule entryRule, Rule exitRule) {
        if (entryRule == null || exitRule == null) {
            throw new IllegalArgumentException("Rules cannot be null");
        }
        this.entryRule = entryRule;
        this.exitRule = exitRule;
    }

    public boolean isUnstableAt(int index) {
        return index < this.unstablePeriod;
    }

    public void setUnstablePeriod(int unstablePeriod) {
        this.unstablePeriod = unstablePeriod;
    }

    public boolean shouldOperate(int index, TradingRecord tradingRecord) {
        Trade trade = tradingRecord.getCurrentTrade();
        if (trade.isNew()) {
            return this.shouldEnter(index, tradingRecord);
        }
        if (trade.isOpened()) {
            return this.shouldExit(index, tradingRecord);
        }
        return false;
    }

    public boolean shouldEnter(int index) {
        return this.shouldEnter(index, null);
    }

    public boolean shouldEnter(int index, TradingRecord tradingRecord) {
        if (this.isUnstableAt(index)) {
            return false;
        }
        boolean enter = this.entryRule.isSatisfied(index, tradingRecord);
        this.traceShouldEnter(index, enter);
        return enter;
    }

    public boolean shouldExit(int index) {
        return this.shouldExit(index, null);
    }

    public boolean shouldExit(int index, TradingRecord tradingRecord) {
        if (this.isUnstableAt(index)) {
            return false;
        }
        boolean exit = this.exitRule.isSatisfied(index, tradingRecord);
        this.traceShouldExit(index, exit);
        return exit;
    }

    protected void traceShouldEnter(int index, boolean enter) {
        this.log.trace(">>> {}#shouldEnter({}): {}", new Object[]{this.getClass().getSimpleName(), index, enter});
    }

    protected void traceShouldExit(int index, boolean exit) {
        this.log.trace(">>> {}#shouldExit({}): {}", new Object[]{this.getClass().getSimpleName(), index, exit});
    }
}

