/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Decimal;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class Tick {
    private Period timePeriod;
    private DateTime endTime;
    private DateTime beginTime;
    private Decimal openPrice = null;
    private Decimal closePrice = null;
    private Decimal maxPrice = null;
    private Decimal minPrice = null;
    private Decimal amount = Decimal.ZERO;
    private Decimal volume = Decimal.ZERO;
    private int trades = 0;

    public Tick(Period timePeriod, DateTime endTime) {
        this.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus((ReadablePeriod)timePeriod);
    }

    public Tick(DateTime endTime, double openPrice, double highPrice, double lowPrice, double closePrice, double volume) {
        this(endTime, Decimal.valueOf(openPrice), Decimal.valueOf(highPrice), Decimal.valueOf(lowPrice), Decimal.valueOf(closePrice), Decimal.valueOf(volume));
    }

    public Tick(DateTime endTime, String openPrice, String highPrice, String lowPrice, String closePrice, String volume) {
        this(endTime, Decimal.valueOf(openPrice), Decimal.valueOf(highPrice), Decimal.valueOf(lowPrice), Decimal.valueOf(closePrice), Decimal.valueOf(volume));
    }

    public Tick(DateTime endTime, Decimal openPrice, Decimal highPrice, Decimal lowPrice, Decimal closePrice, Decimal volume) {
        this(Period.days((int)1), endTime, openPrice, highPrice, lowPrice, closePrice, volume);
    }

    public Tick(Period timePeriod, DateTime endTime, Decimal openPrice, Decimal highPrice, Decimal lowPrice, Decimal closePrice, Decimal volume) {
        this.checkTimeArguments(timePeriod, endTime);
        this.timePeriod = timePeriod;
        this.endTime = endTime;
        this.beginTime = endTime.minus((ReadablePeriod)timePeriod);
        this.openPrice = openPrice;
        this.maxPrice = highPrice;
        this.minPrice = lowPrice;
        this.closePrice = closePrice;
        this.volume = volume;
    }

    public Decimal getClosePrice() {
        return this.closePrice;
    }

    public Decimal getOpenPrice() {
        return this.openPrice;
    }

    public int getTrades() {
        return this.trades;
    }

    public Decimal getMaxPrice() {
        return this.maxPrice;
    }

    public Decimal getAmount() {
        return this.amount;
    }

    public Decimal getVolume() {
        return this.volume;
    }

    public void addTrade(double tradeAmount, double tradePrice) {
        this.addTrade(Decimal.valueOf(tradeAmount), Decimal.valueOf(tradePrice));
    }

    public void addTrade(String tradeAmount, String tradePrice) {
        this.addTrade(Decimal.valueOf(tradeAmount), Decimal.valueOf(tradePrice));
    }

    public void addTrade(Decimal tradeAmount, Decimal tradePrice) {
        if (this.openPrice == null) {
            this.openPrice = tradePrice;
        }
        this.closePrice = tradePrice;
        if (this.maxPrice == null) {
            this.maxPrice = tradePrice;
        } else {
            Decimal decimal = this.maxPrice = this.maxPrice.isLessThan(tradePrice) ? tradePrice : this.maxPrice;
        }
        this.minPrice = this.minPrice == null ? tradePrice : (this.minPrice.isGreaterThan(tradePrice) ? tradePrice : this.minPrice);
        this.amount = this.amount.plus(tradeAmount);
        this.volume = this.volume.plus(tradeAmount.multipliedBy(tradePrice));
        ++this.trades;
    }

    public Decimal getMinPrice() {
        return this.minPrice;
    }

    public Period getTimePeriod() {
        return this.timePeriod;
    }

    public DateTime getBeginTime() {
        return this.beginTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return String.format("[time: %1$td/%1$tm/%1$tY %1$tH:%1$tM:%1$tS, close price: %2$f]", this.endTime.toGregorianCalendar(), this.closePrice.toDouble());
    }

    public boolean inPeriod(DateTime timestamp) {
        return timestamp != null && !timestamp.isBefore((ReadableInstant)this.beginTime) && timestamp.isBefore((ReadableInstant)this.endTime);
    }

    public boolean isBearish() {
        return this.openPrice != null && this.closePrice != null && this.closePrice.isLessThan(this.openPrice);
    }

    public boolean isBullish() {
        return this.openPrice != null && this.closePrice != null && this.openPrice.isLessThan(this.closePrice);
    }

    public String getDateName() {
        return this.endTime.toString("hh:mm dd/MM/yyyy");
    }

    public String getSimpleDateName() {
        return this.endTime.toString("dd/MM/yyyy");
    }

    private void checkTimeArguments(Period timePeriod, DateTime endTime) throws IllegalArgumentException {
        if (timePeriod == null) {
            throw new IllegalArgumentException("Time period cannot be null");
        }
        if (endTime == null) {
            throw new IllegalArgumentException("End time cannot be null");
        }
    }
}

