/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.AnalysisCriterion;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;
import eu.verdelhan.ta4j.analysis.criteria.NumberOfTicksCriterion;
import eu.verdelhan.ta4j.analysis.criteria.TotalProfitCriterion;

public class AverageProfitCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion totalProfit = new TotalProfitCriterion();
    private AnalysisCriterion numberOfTicks = new NumberOfTicksCriterion();

    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        double ticks = this.numberOfTicks.calculate(series, tradingRecord);
        if (ticks == 0.0) {
            return 1.0;
        }
        return Math.pow(this.totalProfit.calculate(series, tradingRecord), 1.0 / ticks);
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        double ticks = this.numberOfTicks.calculate(series, trade);
        if (ticks == 0.0) {
            return 1.0;
        }
        return Math.pow(this.totalProfit.calculate(series, trade), 1.0 / ticks);
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }
}

