/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.CashFlow;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;

public class MaximumDrawdownCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        CashFlow cashFlow = new CashFlow(series, tradingRecord);
        Decimal maximumDrawdown = this.calculateMaximumDrawdown(series, cashFlow);
        return maximumDrawdown.toDouble();
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        if (trade != null && trade.getEntry() != null && trade.getExit() != null) {
            CashFlow cashFlow = new CashFlow(series, trade);
            Decimal maximumDrawdown = this.calculateMaximumDrawdown(series, cashFlow);
            return maximumDrawdown.toDouble();
        }
        return 0.0;
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 < criterionValue2;
    }

    private Decimal calculateMaximumDrawdown(TimeSeries series, CashFlow cashFlow) {
        Decimal maximumDrawdown = Decimal.ZERO;
        Decimal maxPeak = Decimal.ZERO;
        for (int i = series.getBegin(); i <= series.getEnd(); ++i) {
            Decimal drawdown;
            Decimal value = cashFlow.getValue(i);
            if (value.isGreaterThan(maxPeak)) {
                maxPeak = value;
            }
            if (!(drawdown = maxPeak.minus(value).dividedBy(maxPeak)).isGreaterThan(maximumDrawdown)) continue;
            maximumDrawdown = drawdown;
        }
        return maximumDrawdown;
    }
}

