/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;

public class NumberOfTicksCriterion
extends AbstractAnalysisCriterion {
    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        int nTicks = 0;
        for (Trade trade : tradingRecord.getTrades()) {
            nTicks = (int)((double)nTicks + this.calculate(series, trade));
        }
        return nTicks;
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        return 1 + trade.getExit().getIndex() - trade.getEntry().getIndex();
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 < criterionValue2;
    }
}

