/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.AnalysisCriterion;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;

public class VersusBuyAndHoldCriterion
extends AbstractAnalysisCriterion {
    private AnalysisCriterion criterion;

    public VersusBuyAndHoldCriterion(AnalysisCriterion criterion) {
        this.criterion = criterion;
    }

    @Override
    public double calculate(TimeSeries series, TradingRecord tradingRecord) {
        TradingRecord fakeRecord = new TradingRecord();
        fakeRecord.enter(series.getBegin());
        fakeRecord.exit(series.getEnd());
        return this.criterion.calculate(series, tradingRecord) / this.criterion.calculate(series, fakeRecord);
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        TradingRecord fakeRecord = new TradingRecord();
        fakeRecord.enter(series.getBegin());
        fakeRecord.exit(series.getEnd());
        return this.criterion.calculate(series, trade) / this.criterion.calculate(series, fakeRecord);
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 > criterionValue2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (").append(this.criterion).append(')');
        return sb.toString();
    }
}

