/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.candles;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class BullishEngulfingIndicator
extends CachedIndicator<Boolean> {
    private final TimeSeries series;

    public BullishEngulfingIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 1) {
            return false;
        }
        Tick prevTick = this.series.getTick(index - 1);
        Tick currTick = this.series.getTick(index);
        if (prevTick.isBearish() && currTick.isBullish()) {
            Decimal prevOpenPrice = prevTick.getOpenPrice();
            Decimal prevClosePrice = prevTick.getClosePrice();
            Decimal currOpenPrice = currTick.getOpenPrice();
            Decimal currClosePrice = currTick.getClosePrice();
            return currOpenPrice.isLessThan(prevOpenPrice) && currOpenPrice.isLessThan(prevClosePrice) && currClosePrice.isGreaterThan(prevOpenPrice) && currClosePrice.isGreaterThan(prevClosePrice);
        }
        return false;
    }
}

