/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.candles;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.candles.RealBodyIndicator;
import eu.verdelhan.ta4j.indicators.simple.AbsoluteIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class DojiIndicator
extends CachedIndicator<Boolean> {
    private final Indicator<Decimal> bodyHeightInd;
    private final SMAIndicator averageBodyHeightInd;
    private final Decimal factor;

    public DojiIndicator(TimeSeries series, int timeFrame, Decimal bodyFactor) {
        super(series);
        this.bodyHeightInd = new AbsoluteIndicator((Indicator<Decimal>)new RealBodyIndicator(series));
        this.averageBodyHeightInd = new SMAIndicator(this.bodyHeightInd, timeFrame);
        this.factor = bodyFactor;
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 1) {
            return this.bodyHeightInd.getValue(index).isZero();
        }
        Decimal averageBodyHeight = (Decimal)this.averageBodyHeightInd.getValue(index - 1);
        Decimal currentBodyHeight = this.bodyHeightInd.getValue(index);
        return currentBodyHeight.isLessThan(averageBodyHeight.multipliedBy(this.factor));
    }
}

