/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.candles;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.candles.LowerShadowIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class ThreeBlackCrowsIndicator
extends CachedIndicator<Boolean> {
    private final TimeSeries series;
    private final LowerShadowIndicator lowerShadowInd;
    private final SMAIndicator averageLowerShadowInd;
    private final Decimal factor;
    private int whiteCandleIndex = -1;

    public ThreeBlackCrowsIndicator(TimeSeries series, int timeFrame, Decimal factor) {
        super(series);
        this.series = series;
        this.lowerShadowInd = new LowerShadowIndicator(series);
        this.averageLowerShadowInd = new SMAIndicator(this.lowerShadowInd, timeFrame);
        this.factor = factor;
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 3) {
            return false;
        }
        this.whiteCandleIndex = index - 3;
        return this.series.getTick(this.whiteCandleIndex).isBullish() && this.isBlackCrow(index - 2) && this.isBlackCrow(index - 1) && this.isBlackCrow(index);
    }

    private boolean hasVeryShortLowerShadow(int index) {
        Decimal currentLowerShadow = (Decimal)this.lowerShadowInd.getValue(index);
        Decimal averageLowerShadow = (Decimal)this.averageLowerShadowInd.getValue(this.whiteCandleIndex);
        return currentLowerShadow.isLessThan(averageLowerShadow.multipliedBy(this.factor));
    }

    private boolean isDeclining(int index) {
        Tick prevTick = this.series.getTick(index - 1);
        Tick currTick = this.series.getTick(index);
        Decimal prevOpenPrice = prevTick.getOpenPrice();
        Decimal prevClosePrice = prevTick.getClosePrice();
        Decimal currOpenPrice = currTick.getOpenPrice();
        Decimal currClosePrice = currTick.getClosePrice();
        return currOpenPrice.isLessThan(prevOpenPrice) && currOpenPrice.isGreaterThan(prevClosePrice) && currClosePrice.isLessThan(prevClosePrice);
    }

    private boolean isBlackCrow(int index) {
        Tick prevTick = this.series.getTick(index - 1);
        Tick currTick = this.series.getTick(index);
        if (currTick.isBearish()) {
            if (prevTick.isBullish()) {
                return this.hasVeryShortLowerShadow(index) && currTick.getOpenPrice().isLessThan(prevTick.getMaxPrice());
            }
            return this.hasVeryShortLowerShadow(index) && this.isDeclining(index);
        }
        return false;
    }
}

