/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.DirectionalMovementDownIndicator;

public class AverageDirectionalMovementDownIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final int timeFrame;
    private final DirectionalMovementDownIndicator dmdown;

    public AverageDirectionalMovementDownIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.dmdown = new DirectionalMovementDownIndicator(series);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ONE;
        }
        Decimal nbPeriods = Decimal.valueOf(this.timeFrame);
        Decimal nbPeriodsMinusOne = Decimal.valueOf(this.timeFrame - 1);
        return ((Decimal)this.getValue(index - 1)).multipliedBy(nbPeriodsMinusOne).dividedBy(nbPeriods).plus(((Decimal)this.dmdown.getValue(index)).dividedBy(nbPeriods));
    }
}

