/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class DirectionalMovementDownIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;

    public DirectionalMovementDownIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal prevMaxPrice = this.series.getTick(index - 1).getMaxPrice();
        Decimal maxPrice = this.series.getTick(index).getMaxPrice();
        Decimal prevMinPrice = this.series.getTick(index - 1).getMinPrice();
        Decimal minPrice = this.series.getTick(index).getMinPrice();
        if (prevMaxPrice.isGreaterThanOrEqual(maxPrice) && prevMinPrice.isLessThanOrEqual(minPrice) || maxPrice.minus(prevMaxPrice).isGreaterThanOrEqual(prevMinPrice.minus(minPrice))) {
            return Decimal.ZERO;
        }
        return prevMinPrice.minus(minPrice);
    }
}

