/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class DirectionalMovementUpIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;

    public DirectionalMovementUpIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal prevMaxPrice = this.series.getTick(index - 1).getMaxPrice();
        Decimal maxPrice = this.series.getTick(index).getMaxPrice();
        Decimal prevMinPrice = this.series.getTick(index - 1).getMinPrice();
        Decimal minPrice = this.series.getTick(index).getMinPrice();
        if (maxPrice.isLessThan(prevMaxPrice) && minPrice.isGreaterThan(prevMinPrice) || prevMinPrice.minus(minPrice).isEqual(maxPrice.minus(prevMaxPrice))) {
            return Decimal.ZERO;
        }
        if (maxPrice.minus(prevMaxPrice).isGreaterThan(prevMinPrice.minus(minPrice))) {
            return maxPrice.minus(prevMaxPrice);
        }
        return Decimal.ZERO;
    }
}

