/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageDirectionalMovementUpIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageTrueRangeIndicator;

public class DirectionalUpIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> admup;
    private final Indicator<Decimal> atr;
    private int timeFrame;

    public DirectionalUpIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.admup = new AverageDirectionalMovementUpIndicator(series, timeFrame);
        this.atr = new AverageTrueRangeIndicator(series, timeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        return this.admup.getValue(index).dividedBy(this.atr.getValue(index));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

