/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class MeanDeviationIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> indicator;
    private int timeFrame;
    private SMAIndicator sma;

    public MeanDeviationIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.sma = new SMAIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal absoluteDeviations = Decimal.ZERO;
        Decimal average = (Decimal)this.sma.getValue(index);
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int nbValues = index - startIndex + 1;
        for (int i = startIndex; i <= index; ++i) {
            absoluteDeviations = absoluteDeviations.plus(this.indicator.getValue(i).minus(average).abs());
        }
        return absoluteDeviations.dividedBy(Decimal.valueOf(nbValues));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

