/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.oscillators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.simple.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class DPOIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final int timeShift;
    private final Indicator<Decimal> price;
    private final SMAIndicator sma;

    public DPOIndicator(TimeSeries series, int timeFrame) {
        this(new ClosePriceIndicator(series), timeFrame);
    }

    public DPOIndicator(Indicator<Decimal> price, int timeFrame) {
        super(price);
        this.timeFrame = timeFrame;
        this.timeShift = timeFrame / 2 + 1;
        this.price = price;
        this.sma = new SMAIndicator(price, this.timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        return this.price.getValue(index).minus((Decimal)this.sma.getValue(index + this.timeShift));
    }
}

