/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.oscillators;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.simple.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MedianPriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MinPriceIndicator;

public class FisherIndicator
extends RecursiveCachedIndicator<Decimal> {
    private static final Decimal ZERO_DOT_FIVE = Decimal.valueOf("0.5");
    private static final Decimal VALUE_MAX = Decimal.valueOf("0.999");
    private static final Decimal VALUE_MIN = Decimal.valueOf("-0.999");
    private final Indicator<Decimal> price;
    private final Indicator<Decimal> intermediateValue;

    public FisherIndicator(TimeSeries series) {
        this(new MedianPriceIndicator(series), 10);
    }

    public FisherIndicator(Indicator<Decimal> price, int timeFrame) {
        this(price, timeFrame, Decimal.valueOf("0.33"), Decimal.valueOf("0.67"));
    }

    public FisherIndicator(Indicator<Decimal> price, int timeFrame, final Decimal alpha, final Decimal beta) {
        super(price);
        this.price = price;
        final HighestValueIndicator periodHigh = new HighestValueIndicator(new MaxPriceIndicator(price.getTimeSeries()), timeFrame);
        final LowestValueIndicator periodLow = new LowestValueIndicator(new MinPriceIndicator(price.getTimeSeries()), timeFrame);
        this.intermediateValue = new RecursiveCachedIndicator<Decimal>(price){

            @Override
            protected Decimal calculate(int index) {
                if (index <= 0) {
                    return Decimal.ZERO;
                }
                Decimal currentPrice = (Decimal)FisherIndicator.this.price.getValue(index);
                Decimal minL = (Decimal)periodLow.getValue(index);
                Decimal maxH = (Decimal)periodHigh.getValue(index);
                Decimal firstPart = currentPrice.minus(minL).dividedBy(maxH.min(minL)).minus(ZERO_DOT_FIVE);
                Decimal secondPart = alpha.multipliedBy(Decimal.TWO).multipliedBy(firstPart);
                Decimal value = secondPart.plus(beta.multipliedBy((Decimal)this.getValue(index - 1)));
                if (value.isGreaterThan(VALUE_MAX)) {
                    value = VALUE_MAX;
                } else if (value.isLessThan(VALUE_MIN)) {
                    value = VALUE_MIN;
                }
                return value;
            }
        };
    }

    @Override
    protected Decimal calculate(int index) {
        if (index <= 0) {
            return Decimal.ZERO;
        }
        Decimal value = this.intermediateValue.getValue(index);
        Decimal ext = Decimal.ONE.plus(value).dividedBy(Decimal.ONE.minus(value)).log();
        return ext.plus((Decimal)this.getValue(index - 1)).dividedBy(Decimal.TWO);
    }
}

