/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.simple;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class VolumeIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;
    private int timeFrame;

    public VolumeIndicator(TimeSeries series) {
        this(series, 1);
    }

    public VolumeIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.series = series;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        Decimal sumOfVolume = Decimal.ZERO;
        for (int i = startIndex; i <= index; ++i) {
            sumOfVolume = sumOfVolume.plus(this.series.getTick(i).getVolume());
        }
        return sumOfVolume;
    }
}

