/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.statistics.StandardDeviationIndicator;

public class StandardErrorIndicator
extends CachedIndicator<Decimal> {
    private int timeFrame;
    private StandardDeviationIndicator sdev;

    public StandardErrorIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.timeFrame = timeFrame;
        this.sdev = new StandardDeviationIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int numberOfObservations = index - startIndex + 1;
        return ((Decimal)this.sdev.getValue(index)).dividedBy(Decimal.valueOf(Math.sqrt(numberOfObservations)));
    }
}

