/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;

public class VarianceIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> indicator;
    private int timeFrame;
    private SMAIndicator sma;

    public VarianceIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.sma = new SMAIndicator(indicator, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int numberOfObservations = index - startIndex + 1;
        Decimal variance = Decimal.ZERO;
        Decimal average = (Decimal)this.sma.getValue(index);
        for (int i = startIndex; i <= index; ++i) {
            Decimal pow = this.indicator.getValue(i).minus(average).pow(2);
            variance = variance.plus(pow);
        }
        variance = variance.dividedBy(Decimal.valueOf(numberOfObservations));
        return variance;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

