/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageTrueRangeIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.simple.MinPriceIndicator;

public class ChandelierExitShortIndicator
extends CachedIndicator<Decimal> {
    private final LowestValueIndicator low;
    private final AverageTrueRangeIndicator atr;
    private final Decimal k;

    public ChandelierExitShortIndicator(TimeSeries series) {
        this(series, 22, Decimal.THREE);
    }

    public ChandelierExitShortIndicator(TimeSeries series, int timeFrame, Decimal k) {
        super(series);
        this.low = new LowestValueIndicator(new MinPriceIndicator(series), timeFrame);
        this.atr = new AverageTrueRangeIndicator(series, timeFrame);
        this.k = k;
    }

    @Override
    protected Decimal calculate(int index) {
        return ((Decimal)this.low.getValue(index)).plus(((Decimal)this.atr.getValue(index)).multipliedBy(this.k));
    }
}

