/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.DirectionalDownIndicator;
import eu.verdelhan.ta4j.indicators.helpers.DirectionalUpIndicator;

public class DirectionalMovementIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final DirectionalUpIndicator dup;
    private final DirectionalDownIndicator ddown;

    public DirectionalMovementIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.dup = new DirectionalUpIndicator(series, timeFrame);
        this.ddown = new DirectionalDownIndicator(series, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal dupValue = (Decimal)this.dup.getValue(index);
        Decimal ddownValue = (Decimal)this.ddown.getValue(index);
        Decimal difference = dupValue.minus(ddownValue);
        return dupValue.minus(ddownValue).abs().dividedBy(dupValue.plus(ddownValue)).multipliedBy(Decimal.HUNDRED);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

