/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.simple.DifferenceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MultiplierIndicator;
import eu.verdelhan.ta4j.indicators.trackers.WMAIndicator;

public class HMAIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final WMAIndicator sqrtWma;

    public HMAIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.timeFrame = timeFrame;
        WMAIndicator halfWma = new WMAIndicator(indicator, timeFrame / 2);
        WMAIndicator origWma = new WMAIndicator(indicator, timeFrame);
        DifferenceIndicator indicatorForSqrtWma = new DifferenceIndicator(new MultiplierIndicator(halfWma, Decimal.TWO), origWma);
        this.sqrtWma = new WMAIndicator(indicatorForSqrtWma, (int)Math.sqrt(timeFrame));
    }

    @Override
    protected Decimal calculate(int index) {
        return (Decimal)this.sqrtWma.getValue(index);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

