/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class KAMAIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> price;
    private final int timeFrameEffectiveRatio;
    private final Decimal fastest;
    private final Decimal slowest;

    public KAMAIndicator(Indicator<Decimal> price, int timeFrameEffectiveRatio, int timeFrameFast, int timeFrameSlow) {
        super(price);
        this.price = price;
        this.timeFrameEffectiveRatio = timeFrameEffectiveRatio;
        this.fastest = Decimal.TWO.dividedBy(Decimal.valueOf(timeFrameFast + 1));
        this.slowest = Decimal.TWO.dividedBy(Decimal.valueOf(timeFrameSlow + 1));
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal currentPrice = this.price.getValue(index);
        if (index < this.timeFrameEffectiveRatio) {
            return currentPrice;
        }
        int startChangeIndex = Math.max(0, index - this.timeFrameEffectiveRatio);
        Decimal change = currentPrice.minus(this.price.getValue(startChangeIndex)).abs();
        Decimal volatility = Decimal.ZERO;
        for (int i = startChangeIndex; i < index; ++i) {
            volatility = volatility.plus(this.price.getValue(i + 1).minus(this.price.getValue(i)).abs());
        }
        Decimal er = change.dividedBy(volatility);
        Decimal sc = er.multipliedBy(this.fastest.minus(this.slowest)).plus(this.slowest).pow(2);
        Decimal priorKAMA = (Decimal)this.getValue(index - 1);
        return priorKAMA.plus(sc.multipliedBy(currentPrice.minus(priorKAMA)));
    }
}

