/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class TrailingStopLossIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private Decimal stopLossLimit;
    private final Decimal stopLossDistance;

    public TrailingStopLossIndicator(Indicator<Decimal> indicator, Decimal stopLossDistance) {
        this(indicator, stopLossDistance, Decimal.NaN);
    }

    public TrailingStopLossIndicator(Indicator<Decimal> indicator, Decimal stopLossDistance, Decimal initialStopLossLimit) {
        super(indicator);
        this.indicator = indicator;
        this.stopLossDistance = stopLossDistance;
        this.stopLossLimit = initialStopLossLimit;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal referenceValue;
        Decimal currentValue;
        if (this.stopLossLimit.isNaN()) {
            this.stopLossLimit = this.indicator.getValue(0).minus(this.stopLossDistance);
        }
        if ((currentValue = this.indicator.getValue(index)).isGreaterThan(referenceValue = this.stopLossLimit.plus(this.stopLossDistance))) {
            this.stopLossLimit = currentValue.minus(this.stopLossDistance);
        }
        return this.stopLossLimit;
    }
}

