/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.simple.ClosePriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.MinPriceIndicator;

public class WilliamsRIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;
    private MaxPriceIndicator maxPriceIndicator;
    private MinPriceIndicator minPriceIndicator;

    public WilliamsRIndicator(TimeSeries timeSeries, int timeFrame) {
        this(new ClosePriceIndicator(timeSeries), timeFrame, new MaxPriceIndicator(timeSeries), new MinPriceIndicator(timeSeries));
    }

    public WilliamsRIndicator(Indicator<Decimal> indicator, int timeFrame, MaxPriceIndicator maxPriceIndicator, MinPriceIndicator minPriceIndicator) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
        this.maxPriceIndicator = maxPriceIndicator;
        this.minPriceIndicator = minPriceIndicator;
    }

    @Override
    protected Decimal calculate(int index) {
        HighestValueIndicator highestHigh = new HighestValueIndicator(this.maxPriceIndicator, this.timeFrame);
        LowestValueIndicator lowestMin = new LowestValueIndicator(this.minPriceIndicator, this.timeFrame);
        Decimal highestHighPrice = (Decimal)highestHigh.getValue(index);
        Decimal lowestLowPrice = (Decimal)lowestMin.getValue(index);
        return highestHighPrice.minus(this.indicator.getValue(index)).dividedBy(highestHighPrice.minus(lowestLowPrice)).multipliedBy(Decimal.valueOf("-100"));
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

