/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers.bollinger;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.trackers.bollinger.BollingerBandsMiddleIndicator;

public class BollingerBandsLowerIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final BollingerBandsMiddleIndicator bbm;
    private final Decimal k;

    public BollingerBandsLowerIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Decimal> indicator) {
        this(bbm, indicator, Decimal.TWO);
    }

    public BollingerBandsLowerIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Decimal> indicator, Decimal k) {
        super(indicator);
        this.bbm = bbm;
        this.indicator = indicator;
        this.k = k;
    }

    @Override
    protected Decimal calculate(int index) {
        return ((Decimal)this.bbm.getValue(index)).minus(this.indicator.getValue(index).multipliedBy(this.k));
    }

    public Decimal getK() {
        return this.k;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "deviation: " + this.indicator + "series: " + this.bbm;
    }
}

