/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.trackers.bollinger;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.statistics.StandardDeviationIndicator;
import eu.verdelhan.ta4j.indicators.trackers.SMAIndicator;
import eu.verdelhan.ta4j.indicators.trackers.bollinger.BollingerBandsLowerIndicator;
import eu.verdelhan.ta4j.indicators.trackers.bollinger.BollingerBandsMiddleIndicator;
import eu.verdelhan.ta4j.indicators.trackers.bollinger.BollingerBandsUpperIndicator;

public class PercentBIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final BollingerBandsUpperIndicator bbu;
    private final BollingerBandsMiddleIndicator bbm;
    private final BollingerBandsLowerIndicator bbl;

    public PercentBIndicator(Indicator<Decimal> indicator, int timeFrame, Decimal k) {
        super(indicator);
        this.indicator = indicator;
        this.bbm = new BollingerBandsMiddleIndicator((Indicator<Decimal>)new SMAIndicator(indicator, timeFrame));
        StandardDeviationIndicator sd = new StandardDeviationIndicator(indicator, timeFrame);
        this.bbu = new BollingerBandsUpperIndicator(this.bbm, sd, k);
        this.bbl = new BollingerBandsLowerIndicator(this.bbm, sd, k);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal value = this.indicator.getValue(index);
        Decimal upValue = (Decimal)this.bbu.getValue(index);
        Decimal lowValue = (Decimal)this.bbl.getValue(index);
        return value.minus(lowValue).dividedBy(upValue.minus(lowValue));
    }
}

