/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.CloseLocationValueIndicator;

public class AccumulationDistributionIndicator
extends RecursiveCachedIndicator<Decimal> {
    private TimeSeries series;
    private CloseLocationValueIndicator clvIndicator;

    public AccumulationDistributionIndicator(TimeSeries series) {
        super(series);
        this.series = series;
        this.clvIndicator = new CloseLocationValueIndicator(series);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.ZERO;
        }
        Decimal moneyFlowMultiplier = (Decimal)this.clvIndicator.getValue(index);
        Decimal moneyFlowVolume = moneyFlowMultiplier.multipliedBy(this.series.getTick(index).getVolume());
        return moneyFlowVolume.plus((Decimal)this.getValue(index - 1));
    }
}

