/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.simple.TypicalPriceIndicator;
import eu.verdelhan.ta4j.indicators.simple.VolumeIndicator;

public class VWAPIndicator
extends CachedIndicator<Decimal> {
    private final int timeFrame;
    private final Indicator<Decimal> typicalPrice;
    private final Indicator<Decimal> volume;

    public VWAPIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.timeFrame = timeFrame;
        this.typicalPrice = new TypicalPriceIndicator(series);
        this.volume = new VolumeIndicator(series);
    }

    @Override
    protected Decimal calculate(int index) {
        if (index <= 0) {
            return this.typicalPrice.getValue(index);
        }
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        Decimal cumulativeTPV = Decimal.ZERO;
        Decimal cumulativeVolume = Decimal.ZERO;
        for (int i = startIndex; i <= index; ++i) {
            Decimal currentVolume = this.volume.getValue(i);
            cumulativeTPV = cumulativeTPV.plus(this.typicalPrice.getValue(i).multipliedBy(currentVolume));
            cumulativeVolume = cumulativeVolume.plus(currentVolume);
        }
        return cumulativeTPV.dividedBy(cumulativeVolume);
    }
}

