/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.trading.rules;

import eu.verdelhan.ta4j.Rule;
import eu.verdelhan.ta4j.trading.rules.AndRule;
import eu.verdelhan.ta4j.trading.rules.NotRule;
import eu.verdelhan.ta4j.trading.rules.OrRule;
import eu.verdelhan.ta4j.trading.rules.XorRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRule
implements Rule {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Rule and(Rule rule) {
        return new AndRule(this, rule);
    }

    @Override
    public Rule or(Rule rule) {
        return new OrRule(this, rule);
    }

    @Override
    public Rule xor(Rule rule) {
        return new XorRule(this, rule);
    }

    @Override
    public Rule negation() {
        return new NotRule(this);
    }

    @Override
    public boolean isSatisfied(int index) {
        return this.isSatisfied(index, null);
    }

    protected void traceIsSatisfied(int index, boolean isSatisfied) {
        this.log.trace("{}#isSatisfied({}): {}", new Object[]{this.getClass().getSimpleName(), index, isSatisfied});
    }
}

