/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.trading.rules;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.indicators.simple.ConstantIndicator;
import eu.verdelhan.ta4j.trading.rules.AbstractRule;

public class InPipeRule
extends AbstractRule {
    private Indicator<Decimal> upper;
    private Indicator<Decimal> lower;
    private Indicator<Decimal> ref;

    public InPipeRule(Indicator<Decimal> ref, Decimal upper, Decimal lower) {
        this(ref, new ConstantIndicator<Decimal>(upper), new ConstantIndicator<Decimal>(lower));
    }

    public InPipeRule(Indicator<Decimal> ref, Indicator<Decimal> upper, Indicator<Decimal> lower) {
        this.upper = upper;
        this.lower = lower;
        this.ref = ref;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        boolean satisfied = this.ref.getValue(index).isLessThanOrEqual(this.upper.getValue(index)) && this.ref.getValue(index).isGreaterThanOrEqual(this.lower.getValue(index));
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

