/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.trading.rules;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.indicators.simple.ClosePriceIndicator;
import eu.verdelhan.ta4j.trading.rules.AbstractRule;

public class StopGainRule
extends AbstractRule {
    private ClosePriceIndicator closePrice;
    private Decimal gainRatioThreshold;

    public StopGainRule(ClosePriceIndicator closePrice, Decimal gainPercentage) {
        this.closePrice = closePrice;
        this.gainRatioThreshold = Decimal.HUNDRED.plus(gainPercentage).dividedBy(Decimal.HUNDRED);
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Trade currentTrade;
        boolean satisfied = false;
        if (tradingRecord != null && (currentTrade = tradingRecord.getCurrentTrade()).isOpened()) {
            Decimal entryPrice = currentTrade.getEntry().getPrice();
            Decimal currentPrice = (Decimal)this.closePrice.getValue(index);
            satisfied = currentPrice.isGreaterThanOrEqual(entryPrice.multipliedBy(this.gainRatioThreshold));
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

