/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.trading.rules;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.indicators.simple.ClosePriceIndicator;
import eu.verdelhan.ta4j.trading.rules.AbstractRule;

public class StopLossRule
extends AbstractRule {
    private ClosePriceIndicator closePrice;
    private Decimal lossRatioThreshold;

    public StopLossRule(ClosePriceIndicator closePrice, Decimal lossPercentage) {
        this.closePrice = closePrice;
        this.lossRatioThreshold = Decimal.HUNDRED.minus(lossPercentage).dividedBy(Decimal.HUNDRED);
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Trade currentTrade;
        boolean satisfied = false;
        if (tradingRecord != null && (currentTrade = tradingRecord.getCurrentTrade()).isOpened()) {
            Decimal entryPrice = currentTrade.getEntry().getPrice();
            Decimal currentPrice = (Decimal)this.closePrice.getValue(index);
            satisfied = currentPrice.isLessThanOrEqual(entryPrice.multipliedBy(this.lossRatioThreshold));
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

