/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class listclass {
    boolean code;
    boolean constants;
    boolean verbose;
    boolean classdep;
    boolean nocontents;
    boolean recurse;
    Hashtable listedClasses;
    Vector exclude_name;

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                if (stringArray[i].equals("-constants")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-code")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-brief")) {
                    bl3 = false;
                    continue;
                }
                if (stringArray[i].equals("-dependencies")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals("-nocontents")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-recurse")) {
                    bl6 = true;
                    continue;
                }
                if (stringArray[i].equals("-exclude")) {
                    bl7 = true;
                    continue;
                }
                if (stringArray[i].equals("-help")) {
                    System.out.println("Usage: java listclass [-constants] [-code] [-brief] [-dependencies] [-nocontents] [-recurse] class... [-exclude <list>]\n-constants       Print constants table (constant pool)\n-code            Dump byte code of methods\n-brief           Brief listing\n-dependencies    Show class dependencies\n-nocontents      Do not print field/method information\n-recurse         Recurse into dependent classes\n-exclude <list>  Do not list classes beginning with strings in <list>");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown switch " + stringArray[i] + " ignored.");
                continue;
            }
            if (bl7) {
                vector2.addElement(stringArray[i]);
                continue;
            }
            vector.addElement(stringArray[i]);
        }
        if (vector.size() == 0) {
            System.err.println("list: No input files specified");
        } else {
            listclass listclass2 = new listclass(bl, bl2, bl3, bl4, bl5, bl6, vector2);
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.elementAt(i);
                listclass2.list(string);
            }
        }
    }

    public listclass(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Vector vector) {
        this.code = bl;
        this.constants = bl2;
        this.verbose = bl3;
        this.classdep = bl4;
        this.nocontents = bl5;
        this.recurse = bl6;
        this.listedClasses = new Hashtable();
        this.exclude_name = vector;
    }

    public void list(String string) {
        try {
            if (this.listedClasses.get(string) != null || string.startsWith("[")) {
                return;
            }
            for (int i = 0; i < this.exclude_name.size(); ++i) {
                if (!string.startsWith((String)this.exclude_name.elementAt(i))) continue;
                return;
            }
            JavaClass javaClass = string.endsWith(".class") ? new ClassParser(string).parse() : Repository.lookupClass(string);
            if (this.nocontents) {
                System.out.println(javaClass.getClassName());
            } else {
                System.out.println(javaClass);
            }
            if (this.constants) {
                System.out.println(javaClass.getConstantPool());
            }
            if (this.code) {
                listclass.printCode(javaClass.getMethods(), this.verbose);
            }
            if (this.classdep) {
                listclass.printClassDependencies(javaClass.getConstantPool());
            }
            this.listedClasses.put(string, string);
            if (this.recurse) {
                String[] stringArray = listclass.getClassDependencies(javaClass.getConstantPool());
                for (int i = 0; i < stringArray.length; ++i) {
                    this.list(stringArray[i]);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Error loading class " + string + " (" + iOException.getMessage() + ")");
        }
        catch (Exception exception) {
            System.out.println("Error processing class " + string + " (" + exception.getMessage() + ")");
        }
    }

    public static void printClassDependencies(ConstantPool constantPool) {
        String[] stringArray = listclass.getClassDependencies(constantPool);
        System.out.println("Dependencies:");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\t" + stringArray[i]);
        }
    }

    public static String[] getClassDependencies(ConstantPool constantPool) {
        String[] stringArray = new String[constantPool.getLength()];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < constantPool.getLength(); ++i) {
            Constant constant = constantPool.getConstant(i);
            if (constant == null || constant.getTag() != 7) continue;
            ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(((ConstantClass)constant).getNameIndex());
            stringBuffer.setLength(0);
            stringBuffer.append(new String(constantUtf8.getBytes()));
            for (int j = 0; j < stringBuffer.length(); ++j) {
                if (stringBuffer.charAt(j) != '/') continue;
                stringBuffer.setCharAt(j, '.');
            }
            stringArray[n++] = stringBuffer.toString();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static void printCode(Method[] methodArray, boolean bl) {
        for (int i = 0; i < methodArray.length; ++i) {
            System.out.println(methodArray[i]);
            Code code = methodArray[i].getCode();
            if (code == null) continue;
            System.out.println(code.toString(bl));
        }
    }
}

