/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Method;

public class BadResultSetAccess
extends BytecodeScanningDetector {
    private static final Set<String> dbFieldTypesSet = new HashSet<String>(){
        static final long serialVersionUID = -3510636899394546735L;
        {
            this.add("Array");
            this.add("AsciiStream");
            this.add("BigDecimal");
            this.add("BinaryStream");
            this.add("Blob");
            this.add("Boolean");
            this.add("Byte");
            this.add("Bytes");
            this.add("CharacterStream");
            this.add("Clob");
            this.add("Date");
            this.add("Double");
            this.add("Float");
            this.add("Int");
            this.add("Long");
            this.add("Object");
            this.add("Ref");
            this.add("Short");
            this.add("String");
            this.add("Time");
            this.add("Timestamp");
            this.add("UnicodeStream");
            this.add("URL");
        }
    };
    private OpcodeStack stack = new OpcodeStack();
    private BugReporter bugReporter;

    public BadResultSetAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visit(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        try {
            if (seen == 185) {
                String methodName = this.getNameConstantOperand();
                String clsConstant = this.getClassConstantOperand();
                if (clsConstant.equals("java/sql/ResultSet") && (methodName.startsWith("get") && dbFieldTypesSet.contains(methodName.substring(3)) || methodName.startsWith("update") && dbFieldTypesSet.contains(methodName.substring(6))) || clsConstant.equals("java/sql/PreparedStatement") && methodName.startsWith("set") && dbFieldTypesSet.contains(methodName.substring(3))) {
                    OpcodeStack.Item item;
                    String signature = this.getSigConstantOperand();
                    int numParms = PreorderVisitor.getNumberArguments((String)signature);
                    if (this.stack.getStackDepth() >= numParms && "I".equals((item = this.stack.getStackItem(numParms - 1)).getSignature()) && item.couldBeZero()) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, clsConstant.equals("java/sql/PreparedStatement") ? "SQL_BAD_PREPARED_STATEMENT_ACCESS" : "SQL_BAD_RESULTSET_ACCESS", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

