/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.booleans.util;

import fr.lip6.move.pnml.pthlpng.booleans.And;
import fr.lip6.move.pnml.pthlpng.booleans.Bool;
import fr.lip6.move.pnml.pthlpng.booleans.BooleanConstant;
import fr.lip6.move.pnml.pthlpng.booleans.BooleanOperator;
import fr.lip6.move.pnml.pthlpng.booleans.BooleansPackage;
import fr.lip6.move.pnml.pthlpng.booleans.Equality;
import fr.lip6.move.pnml.pthlpng.booleans.Imply;
import fr.lip6.move.pnml.pthlpng.booleans.Inequality;
import fr.lip6.move.pnml.pthlpng.booleans.Not;
import fr.lip6.move.pnml.pthlpng.booleans.Or;
import fr.lip6.move.pnml.pthlpng.terms.util.TermsValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class BooleansValidator
extends EObjectValidator {
    public static final BooleansValidator INSTANCE = new BooleansValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.lip6.move.pnml.pthlpng.booleans";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected TermsValidator termsValidator = TermsValidator.INSTANCE;

    protected EPackage getEPackage() {
        return BooleansPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateEquality((Equality)value, diagnostics, context);
            }
            case 1: {
                return this.validateInequality((Inequality)value, diagnostics, context);
            }
            case 2: {
                return this.validateBooleanConstant((BooleanConstant)value, diagnostics, context);
            }
            case 3: {
                return this.validateOr((Or)value, diagnostics, context);
            }
            case 4: {
                return this.validateBooleanOperator((BooleanOperator)value, diagnostics, context);
            }
            case 5: {
                return this.validateAnd((And)value, diagnostics, context);
            }
            case 6: {
                return this.validateImply((Imply)value, diagnostics, context);
            }
            case 7: {
                return this.validateNot((Not)value, diagnostics, context);
            }
            case 8: {
                return this.validateBool((Bool)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateEquality(Equality equality, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(equality, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(equality, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(equality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEquality_inputOutputTypes(equality, diagnostics, context);
        }
        return result;
    }

    public boolean validateEquality_inputOutputTypes(Equality equality, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateInequality(Inequality inequality, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(inequality, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(inequality, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(inequality, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInequality_inputOutputTypes(inequality, diagnostics, context);
        }
        return result;
    }

    public boolean validateInequality_inputOutputTypes(Inequality inequality, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBooleanConstant(BooleanConstant booleanConstant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(booleanConstant, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(booleanConstant, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(booleanConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(booleanConstant, diagnostics, context);
        }
        return result;
    }

    public boolean validateOr(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(or, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(or, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanOperator_inputOutputTypes(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOr_InputSize(or, diagnostics, context);
        }
        return result;
    }

    public boolean validateOr_InputSize(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBooleanOperator(BooleanOperator booleanOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(booleanOperator, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(booleanOperator, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(booleanOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanOperator_inputOutputTypes(booleanOperator, diagnostics, context);
        }
        return result;
    }

    public boolean validateBooleanOperator_inputOutputTypes(BooleanOperator booleanOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateAnd(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(and, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(and, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanOperator_inputOutputTypes(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAnd_InputSize(and, diagnostics, context);
        }
        return result;
    }

    public boolean validateAnd_InputSize(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateImply(Imply imply, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(imply, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(imply, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanOperator_inputOutputTypes(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateImply_InputSize(imply, diagnostics, context);
        }
        return result;
    }

    public boolean validateImply_InputSize(Imply imply, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNot(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(not, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(not, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanOperator_inputOutputTypes(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNot_InputSize(not, diagnostics, context);
        }
        return result;
    }

    public boolean validateNot_InputSize(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBool(Bool bool, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(bool, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

