/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.hlcorestructure.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.pthlpng.booleans.impl.BooleansFactoryImpl;
import fr.lip6.move.pnml.pthlpng.dots.impl.DotsFactoryImpl;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.Arc;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.HLAnnotation;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.HlcorestructureFactory;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.HlcorestructurePackage;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.ToolInfo;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.impl.HLCoreAnnotationImpl;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.util.HlcorestructureValidator;
import fr.lip6.move.pnml.pthlpng.multisets.impl.MultisetsFactoryImpl;
import fr.lip6.move.pnml.pthlpng.partitions.impl.PartitionsFactoryImpl;
import fr.lip6.move.pnml.pthlpng.terms.Term;
import fr.lip6.move.pnml.pthlpng.terms.impl.TermsFactoryImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class HLAnnotationImpl
extends HLCoreAnnotationImpl
implements HLAnnotation {
    protected Term structure;

    protected HLAnnotationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return HlcorestructurePackage.Literals.HL_ANNOTATION;
    }

    @Override
    public Term getStructure() {
        return this.structure;
    }

    public NotificationChain basicSetStructure(Term newStructure, NotificationChain msgs) {
        Term oldStructure = this.structure;
        this.structure = newStructure;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStructure, (Object)newStructure);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStructure(Term newStructure) {
        if (newStructure != this.structure) {
            NotificationChain msgs = null;
            if (this.structure != null) {
                msgs = ((InternalEObject)this.structure).eInverseRemove((InternalEObject)this, 5, Term.class, msgs);
            }
            if (newStructure != null) {
                msgs = ((InternalEObject)newStructure).eInverseAdd((InternalEObject)this, 5, Term.class, msgs);
            }
            if ((msgs = this.basicSetStructure(newStructure, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newStructure, (Object)newStructure));
        }
    }

    @Override
    public Arc getContainerArc() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Arc)this.eInternalContainer();
    }

    public NotificationChain basicSetContainerArc(Arc newContainerArc, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContainerArc, 4, msgs);
        return msgs;
    }

    @Override
    public void setContainerArc(Arc newContainerArc) {
        if (newContainerArc != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newContainerArc != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newContainerArc)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContainerArc != null) {
                msgs = ((InternalEObject)newContainerArc).eInverseAdd((InternalEObject)this, 7, Arc.class, msgs);
            }
            if ((msgs = this.basicSetContainerArc(newContainerArc, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newContainerArc, (Object)newContainerArc));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.structure != null) {
                    msgs = ((InternalEObject)this.structure).eInverseRemove((InternalEObject)this, -4, null, msgs);
                }
                return this.basicSetStructure((Term)otherEnd, msgs);
            }
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainerArc((Arc)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetStructure(null, msgs);
            }
            case 4: {
                return this.basicSetContainerArc(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, Arc.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getStructure();
            }
            case 4: {
                return this.getContainerArc();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setStructure((Term)newValue);
                return;
            }
            case 4: {
                this.setContainerArc((Arc)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setStructure(null);
                return;
            }
            case 4: {
                this.setContainerArc(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.structure != null;
            }
            case 4: {
                return this.getContainerArc() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toPNML() {
        String top;
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<hlinscription");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (this.getAnnotationgraphics() != null && !(top = this.getAnnotationgraphics().toPNML()).equals("")) {
            sb.append(top);
            haveSons = true;
        }
        if (this.getText() != null) {
            sb.append(headline);
            sb.append("<");
            sb.append("text");
            sb.append(">");
            sb.append(this.getText().toString());
            sb.append("</");
            sb.append("text");
            sb.append(">");
            sb.append(retline);
            haveSons = true;
        }
        if (this.getStructure() != null && !(top = this.getStructure().toPNML()).equals("")) {
            sb.append(headline);
            sb.append("<");
            sb.append("structure");
            sb.append(">");
            sb.append(top);
            sb.append("</");
            sb.append("structure");
            sb.append(">");
            sb.append(retline);
            haveSons = true;
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</hlinscription>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            Object item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("toolspecific")) {
                item = HlcorestructureFactory.eINSTANCE.createToolInfo();
                item.fromPNML(type, idr);
                item.setContainerLabel(this);
                continue;
            }
            if (type.getLocalName().equals("graphics")) {
                item = HlcorestructureFactory.eINSTANCE.createAnnotationGraphics();
                item.fromPNML(type, idr);
                item.setContainerAnnotation(this);
                continue;
            }
            if (type.getLocalName().equals("text")) {
                this.setText(new String(type.getText()));
            }
            if (!type.getLocalName().equals("structure")) continue;
            item = null;
            Iterator iterator2 = type.getChildElements();
            while (iterator2.hasNext()) {
                OMElement subType = (OMElement)iterator2.next();
                if (subType.getLocalName().equals("equality")) {
                    item = new BooleansFactoryImpl().createEquality();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("inequality")) {
                    item = new BooleansFactoryImpl().createInequality();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("booleanconstantt")) {
                    item = new BooleansFactoryImpl().createBooleanConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("or")) {
                    item = new BooleansFactoryImpl().createOr();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("and")) {
                    item = new BooleansFactoryImpl().createAnd();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("imply")) {
                    item = new BooleansFactoryImpl().createImply();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("not")) {
                    item = new BooleansFactoryImpl().createNot();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("dotconstant")) {
                    item = new DotsFactoryImpl().createDotConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("cardinality")) {
                    item = new MultisetsFactoryImpl().createCardinality();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("contains")) {
                    item = new MultisetsFactoryImpl().createContains();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("cardinalityof")) {
                    item = new MultisetsFactoryImpl().createCardinalityOf();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("add")) {
                    item = new MultisetsFactoryImpl().createAdd();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("all")) {
                    item = new MultisetsFactoryImpl().createAll();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("empty")) {
                    item = new MultisetsFactoryImpl().createEmpty();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("numberof")) {
                    item = new MultisetsFactoryImpl().createNumberOf();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("subtract")) {
                    item = new MultisetsFactoryImpl().createSubtract();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("scalarproduct")) {
                    item = new MultisetsFactoryImpl().createScalarProduct();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("gtp")) {
                    item = new PartitionsFactoryImpl().createGreaterThan();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("partitionelementof")) {
                    item = new PartitionsFactoryImpl().createPartitionElementOf();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("ltp")) {
                    item = new PartitionsFactoryImpl().createLessThan();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("variable")) {
                    item = new TermsFactoryImpl().createVariable();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (subType.getLocalName().equals("tuple")) {
                    item = new TermsFactoryImpl().createTuple();
                    item.fromPNML(subType, idr);
                    item.setContainerHLAnnotation(this);
                    continue;
                }
                if (!subType.getLocalName().equals("useroperator")) continue;
                item = new TermsFactoryImpl().createUserOperator();
                item.fromPNML(subType, idr);
                item.setContainerHLAnnotation(this);
            }
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        String top;
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<hlinscription");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        sb.append(">");
        sb.append(retline);
        if (this.getToolspecifics() != null) {
            try {
                HLAnnotationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                item.toPNML(fc);
            }
        }
        if (this.getAnnotationgraphics() != null && !(top = this.getAnnotationgraphics().toPNML()).equals("")) {
            sb.append(top);
        }
        if (this.getText() != null) {
            sb.append(headline);
            sb.append("<");
            sb.append("text");
            sb.append(">");
            sb.append(this.getText().toString());
            sb.append("</");
            sb.append("text");
            sb.append(">");
            sb.append(retline);
        }
        if (this.getStructure() != null && !(top = this.getStructure().toPNML()).equals("")) {
            sb.append(headline);
            sb.append("<");
            sb.append("structure");
            sb.append(">");
            sb.append(top);
            sb.append("</");
            sb.append("structure");
            sb.append(">");
            sb.append(retline);
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</hlinscription>");
        sb.append(retline);
        try {
            HLAnnotationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        HlcorestructureValidator val = new HlcorestructureValidator();
        boolean retour = true;
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        if (this.getAnnotationgraphics() != null) {
            retour &= this.getAnnotationgraphics().validateOCL(diagnostics);
        }
        if (this.getStructure() != null) {
            retour &= this.getStructure().validateOCL(diagnostics);
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

