/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.integers.util;

import fr.lip6.move.pnml.pthlpng.integers.Addition;
import fr.lip6.move.pnml.pthlpng.integers.Division;
import fr.lip6.move.pnml.pthlpng.integers.GreaterThan;
import fr.lip6.move.pnml.pthlpng.integers.GreaterThanOrEqual;
import fr.lip6.move.pnml.pthlpng.integers.HLInteger;
import fr.lip6.move.pnml.pthlpng.integers.HLPNNumber;
import fr.lip6.move.pnml.pthlpng.integers.IntegerOperator;
import fr.lip6.move.pnml.pthlpng.integers.IntegersPackage;
import fr.lip6.move.pnml.pthlpng.integers.LessThan;
import fr.lip6.move.pnml.pthlpng.integers.LessThanOrEqual;
import fr.lip6.move.pnml.pthlpng.integers.Modulo;
import fr.lip6.move.pnml.pthlpng.integers.Multiplication;
import fr.lip6.move.pnml.pthlpng.integers.Natural;
import fr.lip6.move.pnml.pthlpng.integers.NumberConstant;
import fr.lip6.move.pnml.pthlpng.integers.Positive;
import fr.lip6.move.pnml.pthlpng.integers.Subtraction;
import fr.lip6.move.pnml.pthlpng.terms.util.TermsValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class IntegersValidator
extends EObjectValidator {
    public static final IntegersValidator INSTANCE = new IntegersValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.lip6.move.pnml.pthlpng.integers";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected TermsValidator termsValidator = TermsValidator.INSTANCE;

    protected EPackage getEPackage() {
        return IntegersPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateHLPNNumber((HLPNNumber)value, diagnostics, context);
            }
            case 1: {
                return this.validateNatural((Natural)value, diagnostics, context);
            }
            case 2: {
                return this.validatePositive((Positive)value, diagnostics, context);
            }
            case 3: {
                return this.validateHLInteger((HLInteger)value, diagnostics, context);
            }
            case 4: {
                return this.validateNumberConstant((NumberConstant)value, diagnostics, context);
            }
            case 5: {
                return this.validateIntegerOperator((IntegerOperator)value, diagnostics, context);
            }
            case 6: {
                return this.validateAddition((Addition)value, diagnostics, context);
            }
            case 7: {
                return this.validateSubtraction((Subtraction)value, diagnostics, context);
            }
            case 8: {
                return this.validateMultiplication((Multiplication)value, diagnostics, context);
            }
            case 9: {
                return this.validateDivision((Division)value, diagnostics, context);
            }
            case 10: {
                return this.validateModulo((Modulo)value, diagnostics, context);
            }
            case 11: {
                return this.validateGreaterThan((GreaterThan)value, diagnostics, context);
            }
            case 12: {
                return this.validateGreaterThanOrEqual((GreaterThanOrEqual)value, diagnostics, context);
            }
            case 13: {
                return this.validateLessThan((LessThan)value, diagnostics, context);
            }
            case 14: {
                return this.validateLessThanOrEqual((LessThanOrEqual)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateHLPNNumber(HLPNNumber hlpnNumber, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(hlpnNumber, diagnostics, context);
    }

    public boolean validateNatural(Natural natural, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(natural, diagnostics, context);
    }

    public boolean validatePositive(Positive positive, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(positive, diagnostics, context);
    }

    public boolean validateHLInteger(HLInteger hlInteger, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(hlInteger, diagnostics, context);
    }

    public boolean validateNumberConstant(NumberConstant numberConstant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(numberConstant, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(numberConstant, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(numberConstant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNumberConstant_typeType(numberConstant, diagnostics, context);
        }
        return result;
    }

    public boolean validateNumberConstant_typeType(NumberConstant numberConstant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIntegerOperator(IntegerOperator integerOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(integerOperator, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(integerOperator, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(integerOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(integerOperator, diagnostics, context);
        }
        return result;
    }

    public boolean validateIntegerOperator_inputType(IntegerOperator integerOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateAddition(Addition addition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(addition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(addition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(addition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAddition_outputType(addition, diagnostics, context);
        }
        return result;
    }

    public boolean validateAddition_outputType(Addition addition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSubtraction(Subtraction subtraction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(subtraction, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(subtraction, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(subtraction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSubtraction_outputType(subtraction, diagnostics, context);
        }
        return result;
    }

    public boolean validateSubtraction_outputType(Subtraction subtraction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMultiplication(Multiplication multiplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(multiplication, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(multiplication, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(multiplication, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMultiplication_outputType(multiplication, diagnostics, context);
        }
        return result;
    }

    public boolean validateMultiplication_outputType(Multiplication multiplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDivision(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(division, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(division, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDivision_outputType(division, diagnostics, context);
        }
        return result;
    }

    public boolean validateDivision_outputType(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateModulo(Modulo modulo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(modulo, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(modulo, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(modulo, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateModulo_outputType(modulo, diagnostics, context);
        }
        return result;
    }

    public boolean validateModulo_outputType(Modulo modulo, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGreaterThan(GreaterThan greaterThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(greaterThan, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(greaterThan, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGreaterThan_outputType(greaterThan, diagnostics, context);
        }
        return result;
    }

    public boolean validateGreaterThan_outputType(GreaterThan greaterThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGreaterThanOrEqual(GreaterThanOrEqual greaterThanOrEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(greaterThanOrEqual, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(greaterThanOrEqual, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(greaterThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGreaterThanOrEqual_outputType(greaterThanOrEqual, diagnostics, context);
        }
        return result;
    }

    public boolean validateGreaterThanOrEqual_outputType(GreaterThanOrEqual greaterThanOrEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLessThan(LessThan lessThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(lessThan, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(lessThan, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLessThan_outputType(lessThan, diagnostics, context);
        }
        return result;
    }

    public boolean validateLessThan_outputType(LessThan lessThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLessThanOrEqual(LessThanOrEqual lessThanOrEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(lessThanOrEqual, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(lessThanOrEqual, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerOperator_inputType(lessThanOrEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLessThanOrEqual_outputType(lessThanOrEqual, diagnostics, context);
        }
        return result;
    }

    public boolean validateLessThanOrEqual_outputType(LessThanOrEqual lessThanOrEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

