/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.partitions.util;

import fr.lip6.move.pnml.pthlpng.partitions.GreaterThan;
import fr.lip6.move.pnml.pthlpng.partitions.LessThan;
import fr.lip6.move.pnml.pthlpng.partitions.Partition;
import fr.lip6.move.pnml.pthlpng.partitions.PartitionElement;
import fr.lip6.move.pnml.pthlpng.partitions.PartitionElementOf;
import fr.lip6.move.pnml.pthlpng.partitions.PartitionOperator;
import fr.lip6.move.pnml.pthlpng.partitions.PartitionsPackage;
import fr.lip6.move.pnml.pthlpng.terms.util.TermsValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class PartitionsValidator
extends EObjectValidator {
    public static final PartitionsValidator INSTANCE = new PartitionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.lip6.move.pnml.pthlpng.partitions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected TermsValidator termsValidator = TermsValidator.INSTANCE;

    protected EPackage getEPackage() {
        return PartitionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePartition((Partition)value, diagnostics, context);
            }
            case 1: {
                return this.validatePartitionElement((PartitionElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateGreaterThan((GreaterThan)value, diagnostics, context);
            }
            case 3: {
                return this.validatePartitionElementOf((PartitionElementOf)value, diagnostics, context);
            }
            case 4: {
                return this.validatePartitionOperator((PartitionOperator)value, diagnostics, context);
            }
            case 5: {
                return this.validateLessThan((LessThan)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePartition(Partition partition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(partition, diagnostics, context);
    }

    public boolean validatePartitionElement(PartitionElement partitionElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(partitionElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(partitionElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(partitionElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePartitionElement_constantsType(partitionElement, diagnostics, context);
        }
        return result;
    }

    public boolean validatePartitionElement_constantsType(PartitionElement partitionElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateGreaterThan(GreaterThan greaterThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(greaterThan, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(greaterThan, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(greaterThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGreaterThan_inputOutputTypes(greaterThan, diagnostics, context);
        }
        return result;
    }

    public boolean validateGreaterThan_inputOutputTypes(GreaterThan greaterThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePartitionElementOf(PartitionElementOf partitionElementOf, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(partitionElementOf, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(partitionElementOf, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(partitionElementOf, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePartitionElementOf_inputOutputTypes(partitionElementOf, diagnostics, context);
        }
        return result;
    }

    public boolean validatePartitionElementOf_inputOutputTypes(PartitionElementOf partitionElementOf, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePartitionOperator(PartitionOperator partitionOperator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(partitionOperator, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(partitionOperator, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(partitionOperator, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(partitionOperator, diagnostics, context);
        }
        return result;
    }

    public boolean validateLessThan(LessThan lessThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(lessThan, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(lessThan, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.termsValidator.validateOperator_sameOperatorNTermSort(lessThan, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLessThan_inputOutputTypes(lessThan, diagnostics, context);
        }
        return result;
    }

    public boolean validateLessThan_inputOutputTypes(LessThan lessThan, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

