/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.ptnet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FontDecoration implements Enumerator
{
    UNDERLINE(0, "UNDERLINE", "underline"),
    OVERLINE(1, "OVERLINE", "overline"),
    LINETHROUGH(2, "LINETHROUGH", "linethrough");

    public static final int UNDERLINE_VALUE = 0;
    public static final int OVERLINE_VALUE = 1;
    public static final int LINETHROUGH_VALUE = 2;
    private static final FontDecoration[] VALUES_ARRAY;
    public static final List<FontDecoration> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FontDecoration[]{UNDERLINE, OVERLINE, LINETHROUGH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FontDecoration get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontDecoration result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontDecoration getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontDecoration result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontDecoration get(int value) {
        switch (value) {
            case 0: {
                return UNDERLINE;
            }
            case 1: {
                return OVERLINE;
            }
            case 2: {
                return LINETHROUGH;
            }
        }
        return null;
    }

    private FontDecoration(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

