/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.booleans.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.symmetricnet.booleans.BooleanConstant;
import fr.lip6.move.pnml.symmetricnet.booleans.BooleansPackage;
import fr.lip6.move.pnml.symmetricnet.booleans.impl.BooleansFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.impl.CyclicEnumerationsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.dots.impl.DotsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.finiteIntRanges.impl.FiniteIntRangesFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.integers.impl.IntegersFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.multisets.impl.MultisetsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.partitions.impl.PartitionsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.terms.Term;
import fr.lip6.move.pnml.symmetricnet.terms.impl.BuiltInConstantImpl;
import fr.lip6.move.pnml.symmetricnet.terms.impl.TermsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class BooleanConstantImpl
extends BuiltInConstantImpl
implements BooleanConstant {
    protected static final Boolean VALUE_EDEFAULT = null;
    protected Boolean value = VALUE_EDEFAULT;

    protected BooleanConstantImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return BooleansPackage.Literals.BOOLEAN_CONSTANT;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean newValue) {
        Boolean oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setValue((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    @Override
    public String toPNML() {
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<booleanconstantt");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getValue() != null) {
            sb.append(" value");
            sb.append("=\"");
            sb.append(this.getValue());
            sb.append("\"");
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getSubterm() != null) {
            List<Term> items = this.getSubterm();
            for (Term item : items) {
                sb.append(headline);
                sb.append("<");
                sb.append("subterm");
                sb.append(">");
                sb.append(item.toPNML());
                sb.append(headline);
                sb.append("</");
                sb.append("subterm");
                sb.append(">");
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</booleanconstantt>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        if (locRoot.getAttributeValue(new QName("value")) != null) {
            try {
                this.setValue(new Boolean(locRoot.getAttributeValue(new QName("value"))));
            }
            catch (Exception e) {
                throw new InnerBuildException((Throwable)e);
            }
        }
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            OMElement type = (OMElement)iterator.next();
            if (!type.getLocalName().equals("subterm")) continue;
            Term item = null;
            Iterator iterator2 = type.getChildElements();
            while (iterator2.hasNext()) {
                OMElement subType = (OMElement)iterator2.next();
                if (subType.getLocalName().equals("equality")) {
                    item = new BooleansFactoryImpl().createEquality();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("inequality")) {
                    item = new BooleansFactoryImpl().createInequality();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("booleanconstantt")) {
                    item = new BooleansFactoryImpl().createBooleanConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("or")) {
                    item = new BooleansFactoryImpl().createOr();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("and")) {
                    item = new BooleansFactoryImpl().createAnd();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("imply")) {
                    item = new BooleansFactoryImpl().createImply();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("not")) {
                    item = new BooleansFactoryImpl().createNot();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("successor")) {
                    item = new CyclicEnumerationsFactoryImpl().createSuccessor();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("predecessor")) {
                    item = new CyclicEnumerationsFactoryImpl().createPredecessor();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("dotconstant")) {
                    item = new DotsFactoryImpl().createDotConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("finiteintrangeconstant")) {
                    item = new FiniteIntRangesFactoryImpl().createFiniteIntRangeConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("lessthan")) {
                    item = new FiniteIntRangesFactoryImpl().createLessThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("greaterthan")) {
                    item = new FiniteIntRangesFactoryImpl().createGreaterThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("lessthanorequal")) {
                    item = new FiniteIntRangesFactoryImpl().createLessThanOrEqual();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("greaterthanorequal")) {
                    item = new FiniteIntRangesFactoryImpl().createGreaterThanOrEqual();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("numberconstant")) {
                    item = new IntegersFactoryImpl().createNumberConstant();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("addition")) {
                    item = new IntegersFactoryImpl().createAddition();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("subtraction")) {
                    item = new IntegersFactoryImpl().createSubtraction();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("mult")) {
                    item = new IntegersFactoryImpl().createMultiplication();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("div")) {
                    item = new IntegersFactoryImpl().createDivision();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("mod")) {
                    item = new IntegersFactoryImpl().createModulo();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("gt")) {
                    item = new IntegersFactoryImpl().createGreaterThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("geq")) {
                    item = new IntegersFactoryImpl().createGreaterThanOrEqual();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("lt")) {
                    item = new IntegersFactoryImpl().createLessThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("leq")) {
                    item = new IntegersFactoryImpl().createLessThanOrEqual();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("cardinality")) {
                    item = new MultisetsFactoryImpl().createCardinality();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("contains")) {
                    item = new MultisetsFactoryImpl().createContains();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("cardinalityof")) {
                    item = new MultisetsFactoryImpl().createCardinalityOf();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("add")) {
                    item = new MultisetsFactoryImpl().createAdd();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("all")) {
                    item = new MultisetsFactoryImpl().createAll();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("empty")) {
                    item = new MultisetsFactoryImpl().createEmpty();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("numberof")) {
                    item = new MultisetsFactoryImpl().createNumberOf();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("subtract")) {
                    item = new MultisetsFactoryImpl().createSubtract();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("scalarproduct")) {
                    item = new MultisetsFactoryImpl().createScalarProduct();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("gtp")) {
                    item = new PartitionsFactoryImpl().createGreaterThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("partitionelementof")) {
                    item = new PartitionsFactoryImpl().createPartitionElementOf();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("ltp")) {
                    item = new PartitionsFactoryImpl().createLessThan();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("variable")) {
                    item = new TermsFactoryImpl().createVariable();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (subType.getLocalName().equals("tuple")) {
                    item = new TermsFactoryImpl().createTuple();
                    item.fromPNML(subType, idr);
                    item.setContainerOperator(this);
                    continue;
                }
                if (!subType.getLocalName().equals("useroperator")) continue;
                item = new TermsFactoryImpl().createUserOperator();
                item.fromPNML(subType, idr);
                item.setContainerOperator(this);
            }
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<booleanconstantt");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getValue() != null) {
            sb.append(" value");
            sb.append("=\"");
            sb.append(this.getValue());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(retline);
        if (this.getSubterm() != null) {
            try {
                BooleanConstantImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<Term> items = this.getSubterm();
            for (Term item : items) {
                sb.append(headline);
                sb.append("<");
                sb.append("subterm");
                sb.append(">");
                try {
                    BooleanConstantImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
                }
                catch (IOException io) {
                    io.printStackTrace();
                    return;
                }
                sb.delete(0, sb.length());
                item.toPNML(fc);
                sb.append(headline);
                sb.append("</");
                sb.append("subterm");
                sb.append(">");
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</booleanconstantt>");
        sb.append(retline);
        try {
            BooleanConstantImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getSubterm() != null) {
            List<Term> items = this.getSubterm();
            for (Term item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

