/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.CyclicEnumeration;
import fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.CyclicEnumerationsPackage;
import fr.lip6.move.pnml.symmetricnet.finiteEnumerations.FEConstant;
import fr.lip6.move.pnml.symmetricnet.finiteEnumerations.FiniteEnumerationsFactory;
import fr.lip6.move.pnml.symmetricnet.finiteEnumerations.impl.FiniteEnumerationImpl;
import fr.lip6.move.pnml.symmetricnet.terms.Sort;
import fr.lip6.move.pnml.symmetricnet.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;

public class CyclicEnumerationImpl
extends FiniteEnumerationImpl
implements CyclicEnumeration {
    protected CyclicEnumerationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CyclicEnumerationsPackage.Literals.CYCLIC_ENUMERATION;
    }

    @Override
    public String toPNML() {
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<cyclicenumeration");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getElements() != null) {
            List<FEConstant> items = this.getElements();
            for (FEConstant item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</cyclicenumeration>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            OMElement type = (OMElement)iterator.next();
            if (!type.getLocalName().equals("feconstant")) continue;
            FEConstant item = FiniteEnumerationsFactory.eINSTANCE.createFEConstant();
            item.fromPNML(type, idr);
            item.setSort(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<cyclicenumeration");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        sb.append(">");
        sb.append(retline);
        if (this.getElements() != null) {
            try {
                CyclicEnumerationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<FEConstant> items = this.getElements();
            for (FEConstant item : items) {
                item.toPNML(fc);
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</cyclicenumeration>");
        sb.append(retline);
        try {
            CyclicEnumerationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getElements() != null) {
            List<FEConstant> items = this.getElements();
            for (FEConstant item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }

    @Override
    public boolean equalSorts(Sort sort) {
        boolean isEqual = false;
        if (this.eClass().getName().equalsIgnoreCase(sort.eClass().getName())) {
            if (this.getContainerNamedSort() != null && sort.getContainerNamedSort() != null) {
                isEqual = this.getContainerNamedSort().getName().equalsIgnoreCase(sort.getContainerNamedSort().getName());
            } else if ("CyclicEnumeration".equalsIgnoreCase(this.eClass().getName())) {
                CyclicEnumerationImpl myFE = this;
                CyclicEnumeration thatFE = (CyclicEnumeration)sort;
                List<FEConstant> myConstants = myFE.getElements();
                List<FEConstant> thoseConstants = thatFE.getElements();
                int i = 0;
                int j = 0;
                while (i < myConstants.size() && j < thoseConstants.size()) {
                    if (!myConstants.get(i).getName().equalsIgnoreCase(thoseConstants.get(j).getName())) {
                        isEqual = false;
                        break;
                    }
                    isEqual = true;
                    ++i;
                    ++j;
                }
            }
        }
        return isEqual;
    }
}

