/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.terms.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.symmetricnet.finiteEnumerations.FiniteEnumerationsFactory;
import fr.lip6.move.pnml.symmetricnet.hlcorestructure.Declaration;
import fr.lip6.move.pnml.symmetricnet.partitions.PartitionsFactory;
import fr.lip6.move.pnml.symmetricnet.terms.Declarations;
import fr.lip6.move.pnml.symmetricnet.terms.TermsDeclaration;
import fr.lip6.move.pnml.symmetricnet.terms.TermsFactory;
import fr.lip6.move.pnml.symmetricnet.terms.TermsPackage;
import fr.lip6.move.pnml.symmetricnet.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class DeclarationsImpl
extends MinimalEObjectImpl
implements Declarations {
    protected EList<TermsDeclaration> declaration;

    protected DeclarationsImpl() {
    }

    protected EClass eStaticClass() {
        return TermsPackage.Literals.DECLARATIONS;
    }

    @Override
    public List<TermsDeclaration> getDeclaration() {
        if (this.declaration == null) {
            this.declaration = new EObjectContainmentWithInverseEList(TermsDeclaration.class, (InternalEObject)this, 0, 2);
        }
        return this.declaration;
    }

    @Override
    public Declaration getContainerDeclaration() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (Declaration)this.eInternalContainer();
    }

    public NotificationChain basicSetContainerDeclaration(Declaration newContainerDeclaration, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContainerDeclaration, 1, msgs);
        return msgs;
    }

    @Override
    public void setContainerDeclaration(Declaration newContainerDeclaration) {
        if (newContainerDeclaration != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newContainerDeclaration != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newContainerDeclaration)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContainerDeclaration != null) {
                msgs = ((InternalEObject)newContainerDeclaration).eInverseAdd((InternalEObject)this, 3, Declaration.class, msgs);
            }
            if ((msgs = this.basicSetContainerDeclaration(newContainerDeclaration, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newContainerDeclaration, (Object)newContainerDeclaration));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getDeclaration()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainerDeclaration((Declaration)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getDeclaration()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetContainerDeclaration(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 3, Declaration.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDeclaration();
            }
            case 1: {
                return this.getContainerDeclaration();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getDeclaration().clear();
                this.getDeclaration().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setContainerDeclaration((Declaration)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getDeclaration().clear();
                return;
            }
            case 1: {
                this.setContainerDeclaration(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.declaration != null && !this.declaration.isEmpty();
            }
            case 1: {
                return this.getContainerDeclaration() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toPNML() {
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<declarations");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getDeclaration() != null) {
            List<TermsDeclaration> items = this.getDeclaration();
            for (TermsDeclaration item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</declarations>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            TermsDeclaration item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("variabledecl")) {
                item = TermsFactory.eINSTANCE.createVariableDecl();
                item.fromPNML(type, idr);
                item.setContainerDeclarations(this);
                continue;
            }
            if (type.getLocalName().equals("namedsort")) {
                item = TermsFactory.eINSTANCE.createNamedSort();
                item.fromPNML(type, idr);
                item.setContainerDeclarations(this);
                continue;
            }
            if (type.getLocalName().equals("namedoperator")) {
                item = TermsFactory.eINSTANCE.createNamedOperator();
                item.fromPNML(type, idr);
                item.setContainerDeclarations(this);
                continue;
            }
            if (type.getLocalName().equals("feconstant")) {
                item = FiniteEnumerationsFactory.eINSTANCE.createFEConstant();
                item.fromPNML(type, idr);
                item.setContainerDeclarations(this);
                continue;
            }
            if (type.getLocalName().equals("partition")) {
                item = PartitionsFactory.eINSTANCE.createPartition();
                item.fromPNML(type, idr);
                item.setContainerDeclarations(this);
                continue;
            }
            if (!type.getLocalName().equals("partitionelement")) continue;
            item = PartitionsFactory.eINSTANCE.createPartitionElement();
            item.fromPNML(type, idr);
            item.setContainerDeclarations(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<declarations");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        sb.append(">");
        sb.append(retline);
        if (this.getDeclaration() != null) {
            try {
                DeclarationsImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<TermsDeclaration> items = this.getDeclaration();
            for (TermsDeclaration item : items) {
                item.toPNML(fc);
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</declarations>");
        sb.append(retline);
        try {
            DeclarationsImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getDeclaration() != null) {
            List<TermsDeclaration> items = this.getDeclaration();
            for (TermsDeclaration item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

