/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.terms.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.symmetricnet.booleans.BooleansFactory;
import fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.CyclicEnumerationsFactory;
import fr.lip6.move.pnml.symmetricnet.dots.DotsFactory;
import fr.lip6.move.pnml.symmetricnet.finiteEnumerations.FiniteEnumerationsFactory;
import fr.lip6.move.pnml.symmetricnet.finiteIntRanges.FiniteIntRangesFactory;
import fr.lip6.move.pnml.symmetricnet.integers.IntegersFactory;
import fr.lip6.move.pnml.symmetricnet.terms.ProductSort;
import fr.lip6.move.pnml.symmetricnet.terms.Sort;
import fr.lip6.move.pnml.symmetricnet.terms.TermsFactory;
import fr.lip6.move.pnml.symmetricnet.terms.TermsPackage;
import fr.lip6.move.pnml.symmetricnet.terms.impl.SortImpl;
import fr.lip6.move.pnml.symmetricnet.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ProductSortImpl
extends SortImpl
implements ProductSort {
    protected EList<Sort> elementSort;

    protected ProductSortImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TermsPackage.Literals.PRODUCT_SORT;
    }

    @Override
    public List<Sort> getElementSort() {
        if (this.elementSort == null) {
            this.elementSort = new EObjectContainmentWithInverseEList(Sort.class, (InternalEObject)this, 8, 3);
        }
        return this.elementSort;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getElementSort()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getElementSort()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getElementSort();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getElementSort().clear();
                this.getElementSort().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getElementSort().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.elementSort != null && !this.elementSort.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toPNML() {
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<productsort");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getElementSort() != null) {
            List<Sort> items = this.getElementSort();
            for (Sort item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</productsort>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            Sort item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("multisetsort")) {
                item = TermsFactory.eINSTANCE.createMultisetSort();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("productsort")) {
                item = TermsFactory.eINSTANCE.createProductSort();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("usersort")) {
                item = TermsFactory.eINSTANCE.createUserSort();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("null")) {
                item = BooleansFactory.eINSTANCE.createBool();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("cyclicenumeration")) {
                item = CyclicEnumerationsFactory.eINSTANCE.createCyclicEnumeration();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("dot")) {
                item = DotsFactory.eINSTANCE.createDot();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("finiteenumeration")) {
                item = FiniteEnumerationsFactory.eINSTANCE.createFiniteEnumeration();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("finiteintrange")) {
                item = FiniteIntRangesFactory.eINSTANCE.createFiniteIntRange();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("natural")) {
                item = IntegersFactory.eINSTANCE.createNatural();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (type.getLocalName().equals("positive")) {
                item = IntegersFactory.eINSTANCE.createPositive();
                item.fromPNML(type, idr);
                item.setContainerProductSort(this);
                continue;
            }
            if (!type.getLocalName().equals("integer")) continue;
            item = IntegersFactory.eINSTANCE.createHLInteger();
            item.fromPNML(type, idr);
            item.setContainerProductSort(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<productsort");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        sb.append(">");
        sb.append(retline);
        if (this.getElementSort() != null) {
            try {
                ProductSortImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<Sort> items = this.getElementSort();
            for (Sort item : items) {
                item.toPNML(fc);
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</productsort>");
        sb.append(retline);
        try {
            ProductSortImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getElementSort() != null) {
            List<Sort> items = this.getElementSort();
            for (Sort item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }

    @Override
    public boolean equalSorts(Sort sort) {
        boolean isEqual = false;
        if (this.eClass().getName().equalsIgnoreCase(sort.eClass().getName())) {
            if (this.getContainerNamedSort() != null && sort.getContainerNamedSort() != null) {
                isEqual = this.getContainerNamedSort().getName().equalsIgnoreCase(sort.getContainerNamedSort().getName());
            } else if ("ProductSort".equalsIgnoreCase(this.eClass().getName())) {
                ProductSortImpl mySort = this;
                ProductSort thatSort = (ProductSort)sort;
                List<Sort> myElements = mySort.getElementSort();
                List<Sort> thoseElements = thatSort.getElementSort();
                int i = 0;
                int j = 0;
                while (i < myElements.size() && j < thoseElements.size()) {
                    if (!myElements.get(i).eClass().getName().equalsIgnoreCase(thoseElements.get(j).eClass().getName())) {
                        isEqual = false;
                        break;
                    }
                    isEqual = true;
                    ++i;
                    ++j;
                }
            }
        }
        return isEqual;
    }
}

