/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.general;

import fr.lip6.move.pnml.framework.hlapi.HLAPIClass;
import fr.lip6.move.pnml.framework.utils.exception.OCLValidationFailed;
import fr.lip6.move.pnml.framework.utils.exception.ValidationFailedException;
import fr.lip6.move.pnml.framework.utils.exception.ValidationProcessException;
import fr.lip6.move.pnml.framework.utils.logging.LogMaster;
import fr.lip6.move.pnml.framework.utils.validation.PnmlRngValidation;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.slf4j.Logger;
import org.xml.sax.InputSource;

public abstract class AbstractPnmlImportExport {
    protected final Logger log;
    protected final String newTypeFilePath;
    private boolean checkOcl = true;
    private boolean validateFile = true;

    protected AbstractPnmlImportExport(String loggername, String filePath) {
        this.log = LogMaster.getLogger(loggername);
        this.newTypeFilePath = filePath;
    }

    protected final void oclChecking(HLAPIClass rootclass) throws OCLValidationFailed {
        if (this.checkOcl) {
            BasicDiagnostic diagnostics = new BasicDiagnostic();
            if (!rootclass.validateOCL((DiagnosticChain)diagnostics)) {
                this.log.trace(diagnostics.toString());
                for (Diagnostic diag : diagnostics.getChildren()) {
                    this.log.error(diag.getMessage());
                }
                throw new OCLValidationFailed(diagnostics.getException());
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("OCL checking disabled");
        }
    }

    protected final void rngGrammarValidation(String schemafile, InputSource pnmldocStream) throws ValidationFailedException {
        block8: {
            if (this.validateFile && schemafile != null) {
                PnmlRngValidation validator = new PnmlRngValidation();
                try {
                    if (!validator.validatePnmlDoc(schemafile, pnmldocStream)) {
                        throw new ValidationFailedException("this document does not conform to the " + schemafile + " specifications");
                    }
                    break block8;
                }
                catch (ValidationProcessException validationProcessException) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("Grammar file errors have been raised, the validation can't be done, process will continue without Grammar validation");
                    }
                    break block8;
                }
            }
            if (this.log.isWarnEnabled()) {
                if (this.validateFile) {
                    this.log.warn("no XML grammar associated to this library");
                } else {
                    this.log.warn("XML validation disabled");
                }
            }
        }
    }

    public final boolean isCheckOclEnabled() {
        return this.checkOcl;
    }

    public final void enableOclChecking() {
        this.checkOcl = true;
    }

    public final void disableOclChecking() {
        this.checkOcl = false;
    }

    public final boolean isGrammarValidationEnabled() {
        return this.validateFile;
    }

    public final void enableGrammarValidation() {
        this.validateFile = true;
    }

    public final void disableGrammarValidation() {
        this.validateFile = false;
    }
}

