/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.general;

import fr.lip6.move.pnml.framework.general.CustomPNMLFileType;
import fr.lip6.move.pnml.framework.general.PNMLFileRepository;
import fr.lip6.move.pnml.framework.utils.exception.BadFileFormatException;
import fr.lip6.move.pnml.framework.utils.exception.OtherException;
import fr.lip6.move.pnml.framework.utils.logging.LogMaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.slf4j.Logger;

public class ImportCustomPNMLFileType
implements PNMLFileRepository {
    public static final int NBFIELD = 4;
    private final Logger log = LogMaster.getLogger("customTypes");
    private final List<CustomPNMLFileType> oPNML = new ArrayList<CustomPNMLFileType>();

    public ImportCustomPNMLFileType(String filePath) throws IOException, BadFileFormatException, OtherException {
        QName namespaceQ = new QName("namespace");
        QName rngurlQ = new QName("rngurl");
        QName nametype = new QName("typename");
        OMElement root = this.getDocument(filePath);
        Iterator iter = root.getChildrenWithLocalName("pnmlcustomtype");
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String rootClass = "";
            String fallbackclass = "";
            String nameSpace = element.getAttributeValue(namespaceQ);
            String rngURL = element.getAttributeValue(rngurlQ);
            String typeName = element.getAttributeValue(nametype);
            if (nameSpace == null || nameSpace.equals("")) {
                throw new BadFileFormatException("missing name space");
            }
            if (typeName == null || typeName.equals("")) {
                throw new BadFileFormatException("missing type name");
            }
            Iterator iter2 = element.getChildElements();
            while (iter2.hasNext()) {
                OMElement subelement = (OMElement)iter2.next();
                if (subelement.getLocalName().equals("rootclass")) {
                    rootClass = subelement.getText().trim();
                    continue;
                }
                if (!subelement.getLocalName().equals("fallbackclass")) continue;
                fallbackclass = subelement.getText().trim();
            }
            CustomPNMLFileType cst = new CustomPNMLFileType(typeName, rootClass, nameSpace, rngURL, fallbackclass);
            this.oPNML.add(cst);
        }
    }

    @Override
    public final CustomPNMLFileType getByNamespace(String namespace) {
        CustomPNMLFileType retour = null;
        for (CustomPNMLFileType type : this.oPNML) {
            if (!type.getNamespace().equals(namespace)) continue;
            retour = type;
            break;
        }
        return retour;
    }

    @Override
    public final CustomPNMLFileType getByClassName(String classname) {
        CustomPNMLFileType retour = null;
        for (CustomPNMLFileType type : this.oPNML) {
            if (!type.getClassName().equals(classname)) continue;
            retour = type;
            break;
        }
        return retour;
    }

    private OMElement getDocument(String path) throws FileNotFoundException, BadFileFormatException, OtherException {
        File imported = new File(path);
        if (!imported.isFile() || !imported.exists()) {
            throw new FileNotFoundException(String.valueOf(path) + " is not an existing file");
        }
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(new FileReader(imported));
        }
        catch (XMLStreamException e) {
            this.log.error("this file is not a well formated PNML file", (Throwable)e);
            throw new BadFileFormatException("this file is not a well formated PNML file", e);
        }
        catch (FactoryConfigurationError e) {
            throw new OtherException(e);
        }
        OMElement document = new StAXOMBuilder(parser).getDocumentElement();
        return document;
    }
}

